@props(['name', 'label', 'options' => [], 'value' => '', 'required' => false])
<div class="mb-3">
    <label for="{{ $name }}" class="form-label">{{ $label }}</label>
    <select name="{{ $name }}" id="{{ $name }}" @if ($required) required @endif
        class="form-select">
        <option value="">Select...</option>
        @foreach ($options as $optionValue => $optionLabel)
            <option value="{{ $optionValue }}" {{ old($name, $value) == $optionValue ? 'selected' : '' }}>
                {{ $optionLabel }}
            </option>
        @endforeach
    </select>
    @error($name)
        <div class="text-danger small">{{ $message }}</div>
    @enderror
</div>
