<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletes;
use Wizard\Framework\Models\BaseModel;

class Client extends BaseModel
{
    // use HasFactory;
    use SoftDeletes;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'clients';

    /**
     * The model's default values for attributes.
     *
     * @var array
     */
    protected $attributes = [
        // {{ atributeInsertPoint }}
    ];

    protected $casts = [

    ];

    protected $fillable = [
        'name',
        'email',
        'phone_number',
        'address',
        'notes',

    ];

    protected $default_relations = [

    ];

    protected static $filters = [
        'name' => [
            'column_name' => 'name',
            'table' => 'clients',
            'display' => 'Name',
            'type' => 'value',
        ],
        'email' => [
            'column_name' => 'email',
            'table' => 'clients',
            'display' => 'Email',
            'type' => 'value',
        ],
        'phone_number' => [
            'column_name' => 'phone_number',
            'table' => 'clients',
            'display' => 'Phone Number',
            'type' => 'value',
        ],
        'address' => [
            'column_name' => 'address',
            'table' => 'clients',
            'display' => 'Address',
            'type' => 'value',
        ],
        'notes' => [
            'column_name' => 'notes',
            'table' => 'clients',
            'display' => 'Notes',
            'type' => 'value',
        ],

    ];

    public static function get_filters()
    {
        return static::filters;
    }

    // relations

    // BelongsTo

    // HasMany

    // HasManyThrough

    /**
     * Load the default relations for the model.
     *
     * @return $this
     */
    public function load_relations()
    {
        foreach ($this->default_relations as $relation) {
            $this->load($relation);
        }

        return $this;
    }

    /**
     * Retrieve a query builder instance with default relations loaded.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public static function data_query()
    {
        return parent::data_query();
    }

    /**
     * Retrieve a query builder instance with default relations loaded.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public static function get_data(array $validated = [])
    {
        return parent::get_data($validated);
    }
}
