<x-app-layout>
    <x-slot name="header">
        <h2 class="fw-semibold fs-4 text-dark">
            {{ isset($item) ? 'Edit' : 'Create' }} {{ ucfirst('client') }}
        </h2>
    </x-slot>

    <div class="py-5">
        <div class="container">
            <div class="bg-white shadow-sm rounded p-4">
                    <form method="POST" action="{{ isset($item) ? route('clients.update', $item) : route('clients.store') }}">
										@csrf
                    @if (isset($item))
                        @method('PUT')
                    @endif

										<x-form.text
	name="name"
	label="Name"
	:value="request('name', $item?->name ?? '')"
	:required="true"
></x-form.text>

    <x-form.text
	name="email"
	label="Email"
	:value="request('email', $item?->email ?? '')"
	:required="false"
></x-form.text>

    <x-form.text
	name="phone_number"
	label="Phone Number"
	:value="request('phone_number', $item?->phone_number ?? '')"
	:required="false"
></x-form.text>

    <x-form.text
	name="address"
	label="Address"
	:value="request('address', $item?->address ?? '')"
	:required="false"
></x-form.text>

    <x-form.textarea
	name="notes"
	label="Notes"
	:value="request('notes', $item?->notes ?? '')"
	:required="false"
></x-form.textarea>


                    <div class="d-flex justify-content-end">
                        <a href="{{ route('clients.index') }}"
                            class="btn btn-secondary me-2">Back</a>
                        <button type="submit" class="btn btn-primary">
                            {{ isset($item) ? 'Update' : 'Create' }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
