import EasyMDE from "easymde";
import "easymde/dist/easymde.min.css";

document.addEventListener("DOMContentLoaded", function () {
    document
        .querySelectorAll("textarea.markdown-editor")
        .forEach(function (textarea) {
            if (!textarea.classList.contains("easymde-applied")) {
                const easyMDE = new EasyMDE({
                    element: textarea,
                    spellChecker: false,
                    autofocus: false,
                    status: false,
                    minHeight: "150px",
                    toolbar: [
                        "bold",
                        "italic",
                        "heading",
                        "|",
                        "quote",
                        "unordered-list",
                        "ordered-list",
                        "|",
                        "link",
                        "image",
                        "code",
                        "|",
                        "preview",
                        "guide",
                    ],
                    previewClass: ["editor-preview", "github-dark"],
                });
                textarea.classList.add("easymde-applied");
            }
        });
});
