<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Boreal Point</title>
  <style>
    /* --- Global Styles --- */
    body {
      margin: 0;
      font-family: 'Lato', sans-serif;
      line-height: 1.6;
      color: #333;
      background-color: #fff;
    }
    h1, h2, h3 {
      margin-top: 0;
    }
    a.button {
      display: inline-block;
      padding: 0.75em 1.5em;
      margin-top: 1em;
      background: #B22222;
      color: #fff;
      text-decoration: none;
      border-radius: 8px;
      transition: background 0.3s ease;
    }
    a.button:hover {
      background: #8B1A1A;
    }
    section {
      padding: 4em 1em;
      text-align: center;
    }
    .container {
      max-width: 1000px;
      margin: 0 auto;
      padding: 0 1em;
    }
    /* --- Hero Section --- */
    .hero {
      background: linear-gradient(rgba(30,58,95,0.85), rgba(30,58,95,0.85)), 
                  url('/forest_bg.png') no-repeat center center/cover;
      color: #fff;
      padding: 6em 1em;
    }
    .hero h1 {
      font-size: 2.5rem;
      margin-bottom: 0.5em;
    }
    .hero p {
      font-size: 1.25rem;
    }
    /* --- Services Section --- */
    .services {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
      gap: 2em;
      margin-top: 2em;
    }
    .service {
      background: #f8f8f8;
      padding: 2em;
      border-radius: 12px;
      box-shadow: 0 2px 8px rgba(0,0,0,0.05);
    }
    /* --- Contact --- */
    footer {
      background: #1E3A5F;
      color: #fff;
      padding: 2em 1em;
      text-align: center;
    }
    footer a {
      color: #fff;
      text-decoration: underline;
    }
  </style>
</head>
<body>

  <!-- Hero Section -->
  <section class="hero">
    <div class="container">
      <h1>Boreal Point</h1>
      <p>Custom Software Solutions - Built in Canada</p>
      <a href="#contact" class="button">Let’s Talk</a>
    </div>
  </section>

  <!-- About -->
  <section id="about">
    <div class="container">
      <h2>About Us</h2>
      <p>
      At Boreal Point, we design and build custom software that help businesses work smarter, not harder.
      Rooted in Canada, we combine technical expertise with a down-to-earth approach, making technology simple, practical, and reliable.
      
      </p>
    </div>
  </section>

  <!-- Services -->
  <section id="services">
    <div class="container">
      <h2>Our Services</h2>
      <div class="services">
        <div class="service">
          <h3>Custom Business Tools</h3>
          <p>Tailored software to manage your operations with ease.</p>
        </div>
        <div class="service">
          <h3>Workflow Automation</h3>
          <p>Automate repetitive tasks and free up your time.</p>
        </div>
        <div class="service">
          <h3>Web Applications</h3>
          <p>Secure, scalable, and designed for your business.</p>
        </div>
      </div>
    </div>
  </section>

  <!-- Why Choose Us -->
  <section id="why">
    <div class="container">
      <h2>Why Choose Us</h2>
      <p><strong>Tailored for Small Business</strong> – We understand the challenges of small operations.</p>
      <p><strong>Built in Canada</strong> – Local solutions with global standards.</p>
      <p><strong>Simple & Transparent</strong> – Straightforward pricing and no technical jargon.</p>
    </div>
  </section>

  <!-- Contact -->
  <section id="contact">
    <div class="container">
      <h2>Contact Us</h2>
      <p>Let’s build something great together.</p>
      {{-- <p><a href="mailto:info@borealpoint.ca">info@yourcompany.ca</a></p> --}}
      <p>Based in Canada</p>
      {{-- <a href="mailto:info@borealpoint.ca" class="button">Get in Touch</a> --}}
    </div>
  </section>

  <!-- Footer -->
  <footer>
    <p>&copy; 2025 Boreal Point Software Inc. Built in Canada</p>
  </footer>

</body>
</html>

