<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Scripts -->
        @vite(['resources/sass/app.scss', 'resources/js/app.js'])
    </head>
    <body class="bg-light text-dark">
        <div class="d-flex flex-column min-vh-100 justify-content-center align-items-center pt-3 pt-sm-0 bg-light">
            <div>
                <a href="/">
                    <x-application-logo class="w-20 h-20 text-secondary" />
                </a>
            </div>

            <div class="w-100 mt-4 p-4 bg-white shadow-sm overflow-hidden rounded" style="max-width: 32rem;">
                {{ $slot }}
            </div>
        </div>
    </body>
</html>
