<?php

use App\Http\Controllers\ClientController;
use Illuminate\Support\Facades\Route;

Route::controller(ClientController::class)
    ->middleware(['web', 'auth'])
    ->prefix('clients')
    ->as('clients.')
    ->group(function () {
        Route::get('/', 'index')->name('index');
        Route::post('/get_data', 'get_data')->name('get_data');
        Route::get('/create', 'create')->name('create');
        Route::get('/{client}/edit', 'edit')->name('edit');
        Route::get('/{client}', 'show')->name('show');
        Route::get('/{client}/load', 'load')->name('load');

        Route::post('/store', 'store')->name('store');
        Route::put('/udpate/{client}', 'update')->name('update');
        Route::delete('/destroy/{client}', 'destroy')->name('destroy');
    });
