<x-app-layout>
    <x-slot name="header">
        <h2 class="fw-semibold fs-4 text-dark">
            All {{ Str::plural(ucfirst('client')) }}
        </h2>
    </x-slot>

    <div class="py-5">
        <div class="container">
            <div class="bg-white shadow-sm rounded p-4">
            	<div class="d-flex align-items-center justify-content-between mb-3">
            	    <a href="{{ route('clients.create') }}" class="btn btn-primary">
            	        + New {{ ucfirst('client') }}
            	    </a>
            	</div>
                <div id="my-table"></div>
            </div>
        </div>
    </div>

    @include('includes.ServerTable')
    @pushOnce('scripts')
        <meta name="csrf-token" content="{{ csrf_token() }}">
    @endpushOnce
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const el = document.getElementById('my-table');
            if (el) {
                new ServerTable(el, {
                    endpoint: '/clients/get_data',
                    columns: [
            	        {
    name: 'name',
    label: 'Name',
    class: 'p-2'
},

    {
    name: 'email',
    label: 'Email',
    class: 'p-2'
},

    {
    name: 'phone_number',
    label: 'Phone Number',
    class: 'p-2'
},

    {
    name: 'address',
    label: 'Address',
    class: 'p-2'
},

    {
    name: 'notes',
    label: 'Notes',
    class: 'p-2'
},

                        {
                            name: 'actions',
                            label: ' ',
                            render: function(row, col, i) {
                                let actions = `
                                    <div class="d-flex gap-2">
                                        <a href="{{ route('clients.show', 'PLACEHOLDER') }}" class="text-primary">View</a>
                                        <a href="{{ route('clients.edit', 'PLACEHOLDER') }}" class="text-warning">Edit</a>
                                        <form action="{{ route('clients.destroy', 'PLACEHOLDER') }}" method="POST"
                                            class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-link text-danger p-0"
                                                onclick="return confirm('Delete?')">Delete</button>
                                        </form>
                                    </div>
                                    `;
                                actions = actions.split('PLACEHOLDER').join(row.id);
                                return actions;
                            }
                        }
                    ],
                    pageSize: 10,
                    initialSort: [{
                        col: 'created_at',
                        dir: 'desc'
                    }],
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute(
                            'content')
                    },
                    skeleton: `
            <div class="st-table-container">
                <table class="table table-hover">
                    <thead>
                    </thead>
                    <tbody>
                        <!-- Data rows will go here -->
                    </tbody>
                </table>
                <div class="st-controls">
                    <span class="st-pagination"></span>
                    <span class="st-status"></span>
                </div>
            </div>
        `
                });
            }
        });
    </script>
</x-app-layout>
