# Release Notes

## [Unreleased](https://github.com/laravel/breeze/compare/v2.3.8...2.x)

## [v2.3.8](https://github.com/laravel/breeze/compare/v2.3.7...v2.3.8) - 2025-07-18

* [2.x] Bump Livewire to 3.6.4 by [@PerryvanderMeer](https://github.com/PerryvanderMeer) in https://github.com/laravel/breeze/pull/474

## [v2.3.7](https://github.com/laravel/breeze/compare/v2.3.6...v2.3.7) - 2025-06-17

* [2.x] Fix adding middleware group and alias during installation by [@crynobone](https://github.com/crynobone) in https://github.com/laravel/breeze/pull/473

## [v2.3.6](https://github.com/laravel/breeze/compare/v2.3.5...v2.3.6) - 2025-03-06

* Updated Volt version to ^1.7.0 by [@MrPunyapal](https://github.com/MrPunyapal) in https://github.com/laravel/breeze/pull/471

## [v2.3.5](https://github.com/laravel/breeze/compare/v2.3.4...v2.3.5) - 2025-02-19

* Supports Laravel 12 by [@crynobone](https://github.com/crynobone) in https://github.com/laravel/breeze/pull/451

## [v2.3.4](https://github.com/laravel/breeze/compare/v2.3.3...v2.3.4) - 2025-02-11

* update bun lockfile by [@fouteox](https://github.com/fouteox) in https://github.com/laravel/breeze/pull/462
* [2.x] [ApiStack] Remove `node_modules` and associated lock files by [@miclaus](https://github.com/miclaus) in https://github.com/laravel/breeze/pull/467

## [v2.3.3](https://github.com/laravel/breeze/compare/v2.3.2...v2.3.3) - 2025-01-26

* Fix type error in Login component for `setData` function by [@florikodra](https://github.com/florikodra) in https://github.com/laravel/breeze/pull/454
* Fix tsc error in Pages/Auth/Login.tsx on fresh install by [@MariosIgkiempor](https://github.com/MariosIgkiempor) in https://github.com/laravel/breeze/pull/457

## [v2.3.2](https://github.com/laravel/breeze/compare/v2.3.1...v2.3.2) - 2025-01-21

* [2.x] Unpin typescript version for Inertia Vue stack by [@reyberyturiaga](https://github.com/reyberyturiaga) in https://github.com/laravel/breeze/pull/447
* Missing type declaration add to NewPasswordController.php by [@ashokbaruaakas](https://github.com/ashokbaruaakas) in https://github.com/laravel/breeze/pull/449

## [v2.3.1](https://github.com/laravel/breeze/compare/v2.3.0...v2.3.1) - 2025-01-13

* [2.x] Remove tailwind config files on api stack by [@p-nerd](https://github.com/p-nerd) in https://github.com/laravel/breeze/pull/444
* [2.x] Remove redundant `.d.ts` inclusion from `tsconfig.json` by [@panakour](https://github.com/panakour) in https://github.com/laravel/breeze/pull/445

## [v2.3.0](https://github.com/laravel/breeze/compare/v2.2.6...v2.3.0) - 2024-12-14

* Fix typescript version by [@mo7zayed](https://github.com/mo7zayed) in https://github.com/laravel/breeze/pull/442
* Upgrade to Inertia V2 by [@adamjgriffith](https://github.com/adamjgriffith) in https://github.com/laravel/breeze/pull/443

## [v2.2.6](https://github.com/laravel/breeze/compare/v2.2.5...v2.2.6) - 2024-11-20

* [2.x] Supports PHPStan 2 by [@crynobone](https://github.com/crynobone) in https://github.com/laravel/breeze/pull/441

## [v2.2.5](https://github.com/laravel/breeze/compare/v2.2.4...v2.2.5) - 2024-11-12

* fix(ts): remove redundant [@ts-expect-error](https://github.com/ts-expect-error) directives in SSR route setup by [@datlechin](https://github.com/datlechin) in https://github.com/laravel/breeze/pull/434
* Backport JetStream Modal.vue enhancements by [@mrleblanc101](https://github.com/mrleblanc101) in https://github.com/laravel/breeze/pull/435
* Convert array to single line format by [@Rattone](https://github.com/Rattone) in https://github.com/laravel/breeze/pull/436
* [2.x] Replace `Rule` with `ValidationRule` by [@avosalmon](https://github.com/avosalmon) in https://github.com/laravel/breeze/pull/437

## [v2.2.4](https://github.com/laravel/breeze/compare/v2.2.3...v2.2.4) - 2024-10-29

* fix(sanctum): add 127.0.0.1:3000 for proper API auth during local development with 127.0.0.1:3000 by [@ShahAlamShaikat](https://github.com/ShahAlamShaikat) in https://github.com/laravel/breeze/pull/431
* Using the translate function instead of a static value by [@ashkanfekridev](https://github.com/ashkanfekridev) in https://github.com/laravel/breeze/pull/432

## [v2.2.3](https://github.com/laravel/breeze/compare/v2.2.2...v2.2.3) - 2024-10-17

* [2.x] Fixed TypeScript Errors in React SSR Setup with Ziggy Props when Builds by [@akr4m](https://github.com/akr4m) in https://github.com/laravel/breeze/pull/430

## [v2.2.2](https://github.com/laravel/breeze/compare/v2.2.1...v2.2.2) - 2024-10-06

* Update logo to support dark/light theme by [@milewski](https://github.com/milewski) in https://github.com/laravel/breeze/pull/418
* Add hint to clarify how to use multiselect by [@bdweix](https://github.com/bdweix) in https://github.com/laravel/breeze/pull/417
* [2.x] Utilise `Illuminate\Support\php_binary()` by [@crynobone](https://github.com/crynobone) in https://github.com/laravel/breeze/pull/421
* Remove blade unescape for attributes by [@Rattone](https://github.com/Rattone) in https://github.com/laravel/breeze/pull/422
* [2.x] chore: text-input to use [@disabled](https://github.com/disabled) by [@MrPunyapal](https://github.com/MrPunyapal) in https://github.com/laravel/breeze/pull/427
* Updated names of the default functions to match the file names. by [@msamgan](https://github.com/msamgan) in https://github.com/laravel/breeze/pull/428

## [v2.2.1](https://github.com/laravel/breeze/compare/v2.2.0...v2.2.1) - 2024-09-22

* [2.x] Add `pnpm` lockfile to `flushNodeModules` by [@osbre](https://github.com/osbre) in https://github.com/laravel/breeze/pull/411
* [2.x] Add option to install ESLint with Prettier by [@avosalmon](https://github.com/avosalmon) in https://github.com/laravel/breeze/pull/412
* [2.x] Allows GitHub Actions to run directly from GA UI by [@crynobone](https://github.com/crynobone) in https://github.com/laravel/breeze/pull/413
* Refactor: Break long email validation rule into multiple lines by [@Amidope](https://github.com/Amidope) in https://github.com/laravel/breeze/pull/416

## [v2.2.0](https://github.com/laravel/breeze/compare/v2.1.5...v2.2.0) - 2024-09-11

* fix: add clearErrors on DeleteUserForm on closeModal function by [@radumargina](https://github.com/radumargina) in https://github.com/laravel/breeze/pull/406
* check for import.meta.env.SSR instead of import.meta.env.DEV to know… by [@YassineBenh](https://github.com/YassineBenh) in https://github.com/laravel/breeze/pull/409
* Declare global types for React PageProps by [@matsantosz](https://github.com/matsantosz) in https://github.com/laravel/breeze/pull/405

## [v2.1.5](https://github.com/laravel/breeze/compare/v2.1.4...v2.1.5) - 2024-09-09

* Adjust feature request template by [@driesvints](https://github.com/driesvints) in https://github.com/laravel/breeze/pull/401
* [2.x] Add Bun & Deno Support for installStacks (Blade, Livewire, Inertia) by [@thecodechef](https://github.com/thecodechef) in https://github.com/laravel/breeze/pull/403
* [2.x] Eagerly prefetch assets by [@timacdonald](https://github.com/timacdonald) in https://github.com/laravel/breeze/pull/400
* [2.x] Added `bun` & `deno` support to `flushNodeModules()` by [@thecodechef](https://github.com/thecodechef) in https://github.com/laravel/breeze/pull/404
* [2.x] Use Pest as default testing framework by [@timacdonald](https://github.com/timacdonald) in https://github.com/laravel/breeze/pull/402
* Uses Pest 3 by [@nunomaduro](https://github.com/nunomaduro) in https://github.com/laravel/breeze/pull/408

**Full Changelog**: https://github.com/laravel/breeze/compare/v2.1.4...v2.1.5

## [v2.1.4](https://github.com/laravel/breeze/compare/v2.1.3...v2.1.4) - 2024-08-12

* Update User type to match db schema by [@ninjaparade](https://github.com/ninjaparade) in https://github.com/laravel/breeze/pull/399

## [v2.1.3](https://github.com/laravel/breeze/compare/v2.1.2...v2.1.3) - 2024-07-17

* fix clearing password fields on React auth forms by [@daleweaver777](https://github.com/daleweaver777) in https://github.com/laravel/breeze/pull/395

## [v2.1.2](https://github.com/laravel/breeze/compare/v2.1.1...v2.1.2) - 2024-07-05

* [2.x] Replace `switch` with `match` in `dropdown.blade.php` by [@osbre](https://github.com/osbre) in https://github.com/laravel/breeze/pull/393

## [v2.1.1](https://github.com/laravel/breeze/compare/v2.1.0...v2.1.1) - 2024-07-02

* Bump vue-tsc to v2 to fix crash with TypeScript v5.5 by [@daleweaver777](https://github.com/daleweaver777) in https://github.com/laravel/breeze/pull/391

## [v2.1.0](https://github.com/laravel/breeze/compare/v2.0.5...v2.1.0) - 2024-06-06

* Bump `[@headlessui](https://github.com/headlessui)/react` to v2 by [@RobinMalfait](https://github.com/RobinMalfait) in https://github.com/laravel/breeze/pull/389

## [v2.0.5](https://github.com/laravel/breeze/compare/v2.0.4...v2.0.5) - 2024-05-28

* [2.x] Use `[@isset](https://github.com/isset)` directive by [@dasundev](https://github.com/dasundev) in https://github.com/laravel/breeze/pull/388

## [v2.0.4](https://github.com/laravel/breeze/compare/v2.0.3...v2.0.4) - 2024-05-20

* Update RegisteredUserController.php by [@olivsinz](https://github.com/olivsinz) in https://github.com/laravel/breeze/pull/386
* Update NewPasswordController.php by [@olivsinz](https://github.com/olivsinz) in https://github.com/laravel/breeze/pull/385
* Adding bun support within install command by [@Mavv3006](https://github.com/Mavv3006) in https://github.com/laravel/breeze/pull/384
* fix: add `hydrateRoot` when react ssr enabled by [@jrson83](https://github.com/jrson83) in https://github.com/laravel/breeze/pull/387

## [v2.0.3](https://github.com/laravel/breeze/compare/v2.0.2...v2.0.3) - 2024-04-24

* Refactor email verification tests by [@javadihugo](https://github.com/javadihugo) in https://github.com/laravel/breeze/pull/379
* [2.x] Fix React TS errors by [@jessarcher](https://github.com/jessarcher) in https://github.com/laravel/breeze/pull/381
* Remove welcome view by [@taylorotwell](https://github.com/taylorotwell) in https://github.com/laravel/breeze/commit/86cccf3d7ed843fc60738963ed2ed800eaf314d9
* Remove welcome view by [@taylorotwell](https://github.com/taylorotwell) in https://github.com/laravel/breeze/commit/0d97c710d25e69916b84eb8ff4b630c838709c11

## [v2.0.2](https://github.com/laravel/breeze/compare/v2.0.1...v2.0.2) - 2024-04-01

* [2.x] Removes "(experimental)" label by [@nunomaduro](https://github.com/nunomaduro) in https://github.com/laravel/breeze/pull/377

## [v2.0.1](https://github.com/laravel/breeze/compare/v2.0.0...v2.0.1) - 2024-03-21

* Remove duplicate "id" attribute by [@edikurniawan-dev](https://github.com/edikurniawan-dev) in https://github.com/laravel/breeze/pull/368
* Add Laravel Herd by [@mpociot](https://github.com/mpociot) in https://github.com/laravel/breeze/pull/372
* [2.x] Make commands lazy by [@timacdonald](https://github.com/timacdonald) in https://github.com/laravel/breeze/pull/373
* [2.x] Fixes non dark mode on Livewire's `welcome/navigation.blade.php` by [@nunomaduro](https://github.com/nunomaduro) in https://github.com/laravel/breeze/pull/375

## [v2.0.0](https://github.com/laravel/breeze/compare/v1.29.1...v2.0.0) - 2024-03-12

* Adds Laravel 11 support by [@nunomaduro](https://github.com/nunomaduro) in https://github.com/laravel/breeze/pull/331
* Add id to Input component by [@mmkhakdaman](https://github.com/mmkhakdaman) in https://github.com/laravel/breeze/pull/151
* Implement 11.x welcome page design by [@jasonlbeggs](https://github.com/jasonlbeggs) in https://github.com/laravel/breeze/pull/362

## [v1.29.1](https://github.com/laravel/breeze/compare/v1.29.0...v1.29.1) - 2024-03-04

* Updated throttleKey method to meet Str::lower excepted value in LoginRequest stub by [@rileyshannon](https://github.com/rileyshannon) in https://github.com/laravel/breeze/pull/365
* Fix Livewire form validation by [@PerryvanderMeer](https://github.com/PerryvanderMeer) in https://github.com/laravel/breeze/pull/364

## [v1.29.0](https://github.com/laravel/breeze/compare/v1.28.3...v1.29.0) - 2024-02-21

* Update to Ziggy v2 by [@bakerkretzmar](https://github.com/bakerkretzmar) in https://github.com/laravel/breeze/pull/359

## [v1.28.3](https://github.com/laravel/breeze/compare/v1.28.2...v1.28.3) - 2024-02-19

* Improve default auth tests inside the stubs by [@Pilskalns](https://github.com/Pilskalns) in https://github.com/laravel/breeze/pull/358

## [v1.28.2](https://github.com/laravel/breeze/compare/v1.28.1...v1.28.2) - 2024-02-13

* [1.x] Use Livewire's `redirectIntended` function by [@PerryvanderMeer](https://github.com/PerryvanderMeer) in https://github.com/laravel/breeze/pull/352

## [v1.28.1](https://github.com/laravel/breeze/compare/v1.28.0...v1.28.1) - 2024-01-15

* Add default value for useRef calls in .tsx files by [@matthiasweiss](https://github.com/matthiasweiss) in https://github.com/laravel/breeze/pull/348

## [v1.28.0](https://github.com/laravel/breeze/compare/v1.27.0...v1.28.0) - 2024-01-06

* [1.x] Switch to `defineModel` in Vue stubs by [@osbre](https://github.com/osbre) in https://github.com/laravel/breeze/pull/285

## [v1.27.0](https://github.com/laravel/breeze/compare/v1.26.3...v1.27.0) - 2023-12-19

* Update PostCSS version by [@TENIOS](https://github.com/TENIOS) in https://github.com/laravel/breeze/pull/339
* Added a x-on:close-modal.window directive so we can close modal from a livewire function by [@lucidpolygon](https://github.com/lucidpolygon) in https://github.com/laravel/breeze/pull/341
* Improve Ziggy setup in Inertia stacks by [@bakerkretzmar](https://github.com/bakerkretzmar) in https://github.com/laravel/breeze/pull/340
* [1.x] Vite 5 by [@timacdonald](https://github.com/timacdonald) in https://github.com/laravel/breeze/pull/342

## [v1.26.3](https://github.com/laravel/breeze/compare/v1.26.2...v1.26.3) - 2023-12-06

* asserting responses are ok before asserting presence of components by [@da-mask](https://github.com/da-mask) in https://github.com/laravel/breeze/pull/337
* Fix handling of names with single quotes in Livewire navigation by [@dragi-ns](https://github.com/dragi-ns) in https://github.com/laravel/breeze/pull/336
* Change Livewire Rule Attribute to Validate Attribute by [@achmedislamic](https://github.com/achmedislamic) in https://github.com/laravel/breeze/pull/334
* [1.x] Uses `json_encode` like Jetstream by [@nunomaduro](https://github.com/nunomaduro) in https://github.com/laravel/breeze/pull/338

## [v1.26.2](https://github.com/laravel/breeze/compare/v1.26.1...v1.26.2) - 2023-11-24

* refactor: remove unused import by [@hsndmr](https://github.com/hsndmr) in https://github.com/laravel/breeze/pull/328
* Remove unused import statement by [@arifhp86](https://github.com/arifhp86) in https://github.com/laravel/breeze/pull/329
* [1.x] Fix duplicate password fields by [@tonysm](https://github.com/tonysm) in https://github.com/laravel/breeze/pull/33

## [v1.26.1](https://github.com/laravel/breeze/compare/v1.26.0...v1.26.1) - 2023-11-01

- Better Support for RTL by [@joelbutcher](https://github.com/joelbutcher) in https://github.com/laravel/breeze/pull/327

## [v1.26.0](https://github.com/laravel/breeze/compare/v1.25.1...v1.26.0) - 2023-10-29

- Fix Livewire 'remember me' flow for login doesn't remember by [@ebosveld](https://github.com/ebosveld) in https://github.com/laravel/breeze/pull/325
- Beautify Livewire Stack by [@taylorotwell](https://github.com/taylorotwell) in https://github.com/laravel/breeze/pull/326

## [v1.25.1](https://github.com/laravel/breeze/compare/v1.25.0...v1.25.1) - 2023-10-20

- [1.x] Adds `lowercase` validation rule to user's `email` field by [@nunomaduro](https://github.com/nunomaduro) in https://github.com/laravel/breeze/pull/321
- [1.x] Fix React type issue for SSR route by [@parth391](https://github.com/parth391) in https://github.com/laravel/breeze/pull/320
- [1.x] Don't hide options by [@timacdonald](https://github.com/timacdonald) in https://github.com/laravel/breeze/pull/322

## [v1.25.0](https://github.com/laravel/breeze/compare/v1.24.1...v1.25.0) - 2023-10-06

- Adds Livewire Volt Functional API by [@nunomaduro](https://github.com/nunomaduro) in https://github.com/laravel/breeze/pull/318

## [v1.24.1](https://github.com/laravel/breeze/compare/v1.24.0...v1.24.1) - 2023-10-04

- Fix missing class import by [@qwert1x](https://github.com/qwert1x) in https://github.com/laravel/breeze/pull/317

## [v1.24.0](https://github.com/laravel/breeze/compare/v1.23.3...v1.24.0) - 2023-09-20

- Adds Livewire stack 🐙 by [@nunomaduro](https://github.com/nunomaduro) in https://github.com/laravel/breeze/pull/314

## [v1.23.3](https://github.com/laravel/breeze/compare/v1.23.2...v1.23.3) - 2023-09-06

- Add logout tests by [@xiCO2k](https://github.com/xiCO2k) in https://github.com/laravel/breeze/pull/311

## [v1.23.2](https://github.com/laravel/breeze/compare/v1.23.1...v1.23.2) - 2023-09-01

- Highlight Alpine by [@timacdonald](https://github.com/timacdonald) in https://github.com/laravel/breeze/pull/307

## [v1.23.1](https://github.com/laravel/breeze/compare/v1.23.0...v1.23.1) - 2023-08-27

- Replace `array_merge` with spread operator in `HandleInertiaRequests` by [@osbre](https://github.com/osbre) in https://github.com/laravel/breeze/pull/302

## [v1.23.0](https://github.com/laravel/breeze/compare/v1.22.0...v1.23.0) - 2023-08-08

- [1.x] Pest detection by [@jessarcher](https://github.com/jessarcher) in https://github.com/laravel/breeze/pull/300

## [v1.22.0](https://github.com/laravel/breeze/compare/v1.21.2...v1.22.0) - 2023-08-02

- [1.x] Update `[@vitejs](https://github.com/vitejs)/plugin-react` to v4 by [@parth391](https://github.com/parth391) in https://github.com/laravel/breeze/pull/298
- [1.x] Prompts by [@jessarcher](https://github.com/jessarcher) in https://github.com/laravel/breeze/pull/295

## [v1.21.2](https://github.com/laravel/breeze/compare/v1.21.1...v1.21.2) - 2023-06-21

- Fix and standardise transitions by [@timacdonald](https://github.com/timacdonald) in https://github.com/laravel/breeze/pull/293
- Use appName directly from .env in <title> by [@domnantas](https://github.com/domnantas) in https://github.com/laravel/breeze/pull/292

## [v1.21.1](https://github.com/laravel/breeze/compare/v1.21.0...v1.21.1) - 2023-06-16

- Remove implicit form method calls by @Jacobtims in https://github.com/laravel/breeze/pull/290

## [v1.21.0](https://github.com/laravel/breeze/compare/v1.20.2...v1.21.0) - 2023-05-04

- Migrate to modules by @timacdonald in https://github.com/laravel/breeze/pull/246

## [v1.20.2](https://github.com/laravel/breeze/compare/v1.20.1...v1.20.2) - 2023-04-16

- Remove redundant form data in vue stub by @datlechin in https://github.com/laravel/breeze/pull/280
- Add Sanctum Guard by @taylorotwell in https://github.com/laravel/breeze/commit/b010ff3f8cd8e9ae2a2023ca323fba9987157f60

## [v1.20.1](https://github.com/laravel/breeze/compare/v1.20.0...v1.20.1) - 2023-03-28

- Fix ref in react TextInput by @denis-n-ko in https://github.com/laravel/breeze/pull/277
- Update `current_password` rule in ProfileController by @saade in https://github.com/laravel/breeze/pull/278
- Fix Pest test installation for Inertia stack by @jessarcher in https://github.com/laravel/breeze/pull/279

## [v1.20.0](https://github.com/laravel/breeze/compare/v1.19.2...v1.20.0) - 2023-03-20

- Add opt-in TypeScript support by @jessarcher in https://github.com/laravel/breeze/pull/267
- Uses Pest 2 by @nunomaduro in https://github.com/laravel/breeze/pull/274
- API Stub EnsureEmailIsVerified Middleware: Remove unused function arguments in params by @raksbisht in https://github.com/laravel/breeze/pull/264
- Prop consistency by @jessarcher in https://github.com/laravel/breeze/pull/272
- React - Fix potential "undefined" class by @jessarcher in https://github.com/laravel/breeze/pull/271
- React - Remove unnecessary text input wrapper by @jessarcher in https://github.com/laravel/breeze/pull/270
- React - Fix input focusing when password update fails by @jessarcher in https://github.com/laravel/breeze/pull/269
- React - Simplify Form Handler by @jessarcher in https://github.com/laravel/breeze/pull/268
- Fix password-update pest tests by @mtvbrianking in https://github.com/laravel/breeze/pull/273

## [v1.19.2](https://github.com/laravel/breeze/compare/v1.19.1...v1.19.2) - 2023-02-18

- Improve React components by @jessarcher in https://github.com/laravel/breeze/pull/257
- Fix input field Id in ForgotPassword.jsx by @tomdupont in https://github.com/laravel/breeze/pull/262

## [v1.19.1](https://github.com/laravel/breeze/compare/v1.19.0...v1.19.1) - 2023-02-14

### Changed

- Remove link

## [v1.19.0](https://github.com/laravel/breeze/compare/v1.18.2...v1.19.0) - 2023-02-14

### Changed

- Clean up route definition for Single Action Controllers by @istiak-tridip in https://github.com/laravel/breeze/pull/249
- Add translation to placeholder in delete-user-form.blade.php by @castrohenworx in https://github.com/laravel/breeze/pull/250
- Allowed a hardcoded string to be localized by @Wendelstein7 in https://github.com/laravel/breeze/pull/254
- Update font and welcome page by @jessarcher in https://github.com/laravel/breeze/pull/253

### Fixed

- Allows to install `--pest` in Laravel 10 by @driesvints in https://github.com/laravel/breeze/pull/251

### Removed

- Remove unused files from stubs by @emargareten in https://github.com/laravel/breeze/pull/255

## [v1.18.2](https://github.com/laravel/breeze/compare/v1.18.1...v1.18.2) - 2023-02-02

### Changed

- Use autocomplete for all fields for password manager compatibility by @lukearmstrong in https://github.com/laravel/breeze/pull/245

## [v1.18.1](https://github.com/laravel/breeze/compare/v1.18.0...v1.18.1) - 2023-01-31

### Changed

- Inform user of dependency install process by @itxshakil in https://github.com/laravel/breeze/pull/241

### Fixed

- Update nav menu dark text to be consistent with nav link by @RhysLees in https://github.com/laravel/breeze/pull/239

## [v1.18.0](https://github.com/laravel/breeze/compare/v1.17.0...v1.18.0) - 2023-01-18

### Added

- Laravel v10 Support by @driesvints in https://github.com/laravel/breeze/pull/235
- Inertia v1 Support by @jessarcher in https://github.com/laravel/breeze/pull/238

### Changed

- Prompt when the stack argument is not provided by @jessarcher in https://github.com/laravel/breeze/pull/236
- Use Illuminate console components for prompting by @jessarcher in https://github.com/laravel/breeze/pull/237

## [v1.17.0](https://github.com/laravel/breeze/compare/v1.16.1...v1.17.0) - 2023-01-03

### Changed

- Uses PHP Native Type Declarations 🐘  by @nunomaduro in https://github.com/laravel/breeze/pull/201

## [v1.16.1](https://github.com/laravel/breeze/compare/v1.16.0...v1.16.1) - 2022-12-19

### Fixed

- Remove unused vue imports by @dillingham in https://github.com/laravel/breeze/pull/231
- Renamed isFocused prop on TextInput component by @drewmw5 in https://github.com/laravel/breeze/pull/232

## [v1.16.0](https://github.com/laravel/breeze/compare/v1.15.4...v1.16.0) - 2022-12-16

### Added

- [1.x] Vite 4 support by @timacdonald in https://github.com/laravel/breeze/pull/226

### Changed

- Blade stack - Moved duplicated logo component to guest layout by @magdicom in https://github.com/laravel/breeze/pull/228

### Fixed

- Fix typo in delete user forms by @alexcanana in https://github.com/laravel/breeze/pull/225
- Fixed capitalization of autoComplete prop by @drewmw5 in https://github.com/laravel/breeze/pull/230

## [v1.15.4](https://github.com/laravel/breeze/compare/v1.15.3...v1.15.4) - 2022-12-05

### Changed

- Use Default NPM Package Manager of User if Lock File Exists In Base Path by @andrewdwallo in https://github.com/laravel/breeze/pull/224

## [v1.15.3](https://github.com/laravel/breeze/compare/v1.15.2...v1.15.3) - 2022-11-28

### Fixed

- Fix-psr-4-warning by @Kamona-WD in https://github.com/laravel/breeze/pull/221
- Status must be String by @marsuboss in https://github.com/laravel/breeze/pull/219
- Fix close modal with escape keydown and cleanup import react by @fouteox in https://github.com/laravel/breeze/pull/218

## [v1.15.2](https://github.com/laravel/breeze/compare/v1.15.1...v1.15.2) - 2022-11-21

### Fixed

- Fix closing tag by @kaozaza2 in https://github.com/laravel/breeze/pull/213
- Vue code formatting by @jessarcher in https://github.com/laravel/breeze/pull/212
- React formatting by @fouteox in https://github.com/laravel/breeze/pull/214
- Add missing translation methods to Blade stack by @jessarcher in https://github.com/laravel/breeze/pull/215

## [v1.15.1](https://github.com/laravel/breeze/compare/v1.15.0...v1.15.1) - 2022-11-15

### Fixed

- Fix namespace in PasswordUpdateTest.php by @irsyadadl in https://github.com/laravel/breeze/pull/211

## [v1.15.0](https://github.com/laravel/breeze/compare/v1.14.3...v1.15.0) - 2022-11-15

### Added

- Add "Profile" page by @jessarcher in https://github.com/laravel/breeze/pull/205
- Opt-in dark mode support :crescent_moon:  by @jessarcher in https://github.com/laravel/breeze/pull/209

## [v1.14.3](https://github.com/laravel/breeze/compare/v1.14.2...v1.14.3) - 2022-11-06

### Changed

- RegisteredUserController stubs should use the User model name instead of table name in the validators by @viliamjr in https://github.com/laravel/breeze/pull/206

## [v1.14.2](https://github.com/laravel/breeze/compare/v1.14.1...v1.14.2) - 2022-10-26

### Fixed

- Fix preloading in dev by @timacdonald in https://github.com/laravel/breeze/pull/199

## [v1.14.1](https://github.com/laravel/breeze/compare/v1.14.0...v1.14.1) - 2022-10-25

### Changed

- Replace double quote(") with single quote(') by @itxshakil in https://github.com/laravel/breeze/pull/195
- Bump React and Vue Dependencies by @dammy001 in https://github.com/laravel/breeze/pull/197
- Vite preloading by @timacdonald in https://github.com/laravel/breeze/pull/196

## [v1.14.0](https://github.com/laravel/breeze/compare/v1.13.1...v1.14.0) - 2022-09-27

### Added

- Upgrade to React 18 by @kjoedion in https://github.com/laravel/breeze/pull/192

### Changed

- Display errors alongside fields in Blade stack by @jessarcher in https://github.com/laravel/breeze/pull/191
- Consistently use `verified` middleware on `/dashboard` route. by @jessarcher in https://github.com/laravel/breeze/pull/190
- Make Blade app header optional by @jessarcher in https://github.com/laravel/breeze/pull/189

### Fixed

- Fixes `HandleInertiaRequests::handle` related types by @felixdorn in https://github.com/laravel/breeze/pull/193

## [v1.13.1](https://github.com/laravel/breeze/compare/v1.13.0...v1.13.1) - 2022-09-20

### Fixed

- Make app directory consistently lowercase by @jessarcher in https://github.com/laravel/breeze/pull/187

## [v1.13.0](https://github.com/laravel/breeze/compare/v1.12.0...v1.13.0) - 2022-09-06

### Changed

- Remove "Breeze" component prefix by @jessarcher in https://github.com/laravel/breeze/pull/179

## [v1.12.0](https://github.com/laravel/breeze/compare/v1.11.4...v1.12.0) - 2022-08-16

### Changed

- Install NPM dependencies and build assets by @jessarcher in https://github.com/laravel/breeze/pull/180
- Set application home URI to /dashboard by @nikolaynikolaevn in https://github.com/laravel/breeze/pull/181
- Update inertia-laravel by @timacdonald in https://github.com/laravel/breeze/commit/6d95e9aacbe992e19c81d5cd6f7eec994e50dd8d

## [v1.11.4](https://github.com/laravel/breeze/compare/v1.11.3...v1.11.4) - 2022-08-08

### Changed

- Display validation errors alongside their field by @jessarcher in https://github.com/laravel/breeze/pull/175
- Validate the stack argument by @jessarcher in https://github.com/laravel/breeze/pull/178
- Style improvements by @jessarcher in https://github.com/laravel/breeze/pull/177

## [v1.11.3](https://github.com/laravel/breeze/compare/v1.11.2...v1.11.3) - 2022-08-01

### Changed

- Transliterate throttle key by @JurianArie in https://github.com/laravel/breeze/pull/173
- Switch to fonts.bunny.net instead of Google Fonts by @lucasRolff in https://github.com/laravel/breeze/pull/174

## [v1.11.2](https://github.com/laravel/breeze/compare/v1.11.1...v1.11.2) - 2022-07-20

### Changed

- Improved console output by @nunomaduro in https://github.com/laravel/breeze/pull/172

## [v1.11.1](https://github.com/laravel/breeze/compare/v1.11.0...v1.11.1) - 2022-07-20

### Changed

- Vite 3 support by @timacdonald in https://github.com/laravel/breeze/pull/171

## [v1.11.0](https://github.com/laravel/breeze/compare/v1.10.0...v1.11.0) - 2022-07-11

### Changed

- Add default view / routes reloading to breeze stacks by @timacdonald in https://github.com/laravel/breeze/pull/166
- Update SSR directory by @jessarcher in https://github.com/laravel/breeze/pull/168

### Fixed

- Fix: React SSR installation error by @renomureza in https://github.com/laravel/breeze/pull/169

### Removed

- Laravel 8 don't support the vite. by @Jehong-Ahn in https://github.com/laravel/breeze/pull/167

## [v1.10.0](https://github.com/laravel/breeze/compare/v1.9.4...v1.10.0) - 2022-06-28

### Added

- Vite by @jessarcher in https://github.com/laravel/breeze/pull/158

### Fixed

- fix TailwindCSS first party TypeScript types weren't working right by @geisi in https://github.com/laravel/breeze/pull/160
- Bump `@tailwindcss/forms` fix console warning with Vite by @timacdonald in https://github.com/laravel/breeze/pull/161
- Fix ziggy determing current URL when using SSR by @timacdonald in https://github.com/laravel/breeze/pull/163

## [v1.9.4](https://github.com/laravel/breeze/compare/v1.9.3...v1.9.4) - 2022-06-13

### Changed

- Bump TailwindCSS to 3.1 by @geisi in https://github.com/laravel/breeze/pull/156

## [v1.9.3](https://github.com/laravel/breeze/compare/v1.9.2...v1.9.3) - 2022-06-01

### Changed

- Improve Vite compatibility by @jessarcher in https://github.com/laravel/breeze/pull/154

## [v1.9.2](https://github.com/laravel/breeze/compare/v1.9.1...v1.9.2) - 2022-05-30

### Changed

- Simplify Tailwind installation by @jessarcher in https://github.com/laravel/breeze/pull/155

### Fixed

- Fix inability to click dropdown content in React version by @jessarcher in https://github.com/laravel/breeze/pull/153

## [v1.9.1](https://github.com/laravel/breeze/compare/v1.9.0...v1.9.1) - 2022-05-11

### Changed

- Update command comments by @taylorotwell in https://github.com/laravel/breeze/commit/cde98d03954bfcad0c9370c825187b8a579d94e1

## [v1.9.0](https://github.com/laravel/breeze/compare/v1.8.2...v1.9.0) - 2022-03-26

### Added

- Add Inertia SSR Support  by @xiCO2k in https://github.com/laravel/breeze/pull/146

### Changed

- Update cors.php by @trungpv1601 in https://github.com/laravel/breeze/pull/144
- Use `.alias` method from `Mix` by @xiCO2k in https://github.com/laravel/breeze/pull/145

## [v1.8.2](https://github.com/laravel/breeze/compare/v1.8.1...v1.8.2) - 2022-02-21

### Changed

- Remove unused import by @MohmmedAshraf in https://github.com/laravel/breeze/pull/141
- Add routes name to register and login  paths by @alphaolomi in https://github.com/laravel/breeze/pull/140
- Updated Inertia Version to Latest by @As1fAli in https://github.com/laravel/breeze/pull/142

## [v1.8.1](https://github.com/laravel/breeze/compare/v1.7.3...v1.8.1) - 2022-02-15

### Changed

- Update `InitialVueStack` packages to latest by @dammy001 in https://github.com/laravel/breeze/pull/128
- Update `InertiaReactStack` dependencies by @dammy001 in https://github.com/laravel/breeze/pull/130
- Update `BladeStack` dependencies by @dammy001 in https://github.com/laravel/breeze/pull/129
- Don't mix __() and trans() in the same file by @hailwood in https://github.com/laravel/breeze/pull/132
- Group common middleware instead of duplicating by @dammy001 in https://github.com/laravel/breeze/pull/131
- Group common middleware instead of duplicating on inertia-common by @dammy001 in https://github.com/laravel/breeze/pull/135

### Fixed

- Fix assertRedirect in EmailVerificationTest when using API with pest by @lpheller in https://github.com/laravel/breeze/pull/133

## [v1.8.0](https://github.com/laravel/breeze/compare/v1.7.3...v1.8.0) - 2022-02-15

### Changed

- Transition Inertia Vue stubs to `<script setup>` syntax by @jessarcher in https://github.com/laravel/breeze/pull/127

## [v1.7.3](https://github.com/laravel/breeze/compare/v1.7.2...v1.7.3) - 2022-02-15

### Fixed

- Fix url replacement ([5af95ec](https://github.com/laravel/breeze/commit/5af95eca8ee2d18077347a34b74a2658c8356682))

## [v1.7.2](https://github.com/laravel/breeze/compare/v1.7.1...v1.7.2) - 2022-02-08

### Changed

- Remove CSRF token in app layout ([#125](https://github.com/laravel/breeze/pull/125))
- Update Inertia version ([d5f7582](https://github.com/laravel/breeze/commit/d5f7582d4bc4c6af3922eb04782b204bca32e635))

### Fixed

- Api stack EmailVerificationTest assertRedirect ([#122](https://github.com/laravel/breeze/pull/122))

## [v1.7.1 (2022-02-01)](https://github.com/laravel/breeze/compare/v1.7.0...v1.7.1)

### Changed

- Fix exception throwing on older PHP versions ([#120](https://github.com/laravel/breeze/pull/120))

## [v1.7.0 (2022-01-12)](https://github.com/laravel/breeze/compare/v1.6.1...v1.7.0)

### Changed

- Laravel 9 Support ([#119](https://github.com/laravel/breeze/pull/119))

## [v1.6.1 (2022-01-04)](https://github.com/laravel/breeze/compare/v1.6.0...v1.6.1)

### Changed

- Fix Inertia Controllers @return tag and Inertia Vue Input Component [#112](https://github.com/laravel/breeze/pull/112)
- Update outdated dependencies for react stack [#114](https://github.com/laravel/breeze/pull/114)

## [v1.6.0 (2021-12-14)](https://github.com/laravel/breeze/compare/v1.5.0...v1.6.0)

### Changed

- Tailwind CSS v3 support ([#110](https://github.com/laravel/breeze/pull/110))

## [v1.5.0 (2021-12-07)](https://github.com/laravel/breeze/compare/v1.4.3...v1.5.0)

### Added

- Breeze "API" / SPA Stack ([#109](https://github.com/laravel/breeze/pull/109))

### Changed

- Use KeyboardEvent key attribute for Escape ([#108](https://github.com/laravel/breeze/pull/108))

## [v1.4.3 (2021-11-02)](https://github.com/laravel/breeze/compare/v1.4.2...v1.4.3)

### Changed

- Upgrade alpinejs to v3 ([#105](https://github.com/laravel/breeze/pull/105))
- Use dashboard named routes ([#106](https://github.com/laravel/breeze/pull/106))

## [v1.4.2 (2021-09-28)](https://github.com/laravel/breeze/compare/v1.4.1...v1.4.2)

### Changed

- Change namespace ([7b39f9c](https://github.com/laravel/breeze/commit/7b39f9c114c713a7d75ceeb79b4f5efe3d4f682a))

## [v1.4.1 (2021-09-07)](https://github.com/laravel/breeze/compare/v1.4.0...v1.4.1)

### Fixed

- Fixes installation of pest on vue/react stacks ([#100](https://github.com/laravel/breeze/pull/100))

## [v1.4.0 (2021-08-27)](https://github.com/laravel/breeze/compare/v1.3.2...v1.4.0)

### Added

- Pest scaffolding ([#99](https://github.com/laravel/breeze/pull/99))

## [v1.3.2 (2021-08-03)](https://github.com/laravel/breeze/compare/v1.3.1...v1.3.2)

### Changed

- Update url for JS ([eba8457](https://github.com/laravel/breeze/commit/eba8457b2e16d92fb0909e6e4a36f7cf9f50bc78))
- Add Vue file extension to all Vue components imported ([#89](https://github.com/laravel/breeze/pull/89))
- Update `<Link>` tags & implement `<Head>` management (title tag) ([#90](https://github.com/laravel/breeze/pull/90), [4dce8a8](https://github.com/laravel/breeze/commit/4dce8a8c9dd1b0ca23fbe92fa51b17cc5ccd6bb5), [128fd28](https://github.com/laravel/breeze/commit/128fd28e2ebd5fde7730d90b0052d175b887568a), [#94](https://github.com/laravel/breeze/pull/94))

### Fixed

- Change from POST to GET on responsive dashboard link ([#92](https://github.com/laravel/breeze/pull/92))

## [v1.3.1 (2021-06-22)](https://github.com/laravel/breeze/compare/v1.3.0...v1.3.1)

### Fixed

- Fix EmailVerificationTest to pass using Uuids ([#85](https://github.com/laravel/breeze/pull/85))

## [v1.3.0 (2021-06-08)](https://github.com/laravel/breeze/compare/v1.2.3...v1.3.0)

### Changed

- Update Inertia ([c439176](https://github.com/laravel/breeze/commit/c43917630e9b45b78dfd805f152262e08a7d2ffb))
- Update versions ([aa90bfd](https://github.com/laravel/breeze/commit/aa90bfd5b31cedf848087d105b6924b0f120fc99))

## [v1.2.3 (2021-06-08)](https://github.com/laravel/breeze/compare/v1.2.2...v1.2.3)

### Fixed

- Fix purge line to include *.js ([#83](https://github.com/laravel/breeze/pull/83))

## [v1.2.2 (2021-06-01)](https://github.com/laravel/breeze/compare/v1.2.1...v1.2.2)

### Fixed

- Fix CORS policy errors with inertia stack ([#82](https://github.com/laravel/breeze/pull/82))

## [v1.2.1 (2021-05-25)](https://github.com/laravel/breeze/compare/v1.2.0...v1.2.1)

### Fixed

- Fix dropdown ([87e849a](https://github.com/laravel/breeze/commit/87e849a2fd635628d99aa8514e2ee9321decee27))
- Fix link type ([c83d1ac](https://github.com/laravel/breeze/commit/c83d1ac389a58f1fb9ee6491ce14488f6a0a746b))

## [v1.2.0 (2021-05-20)](https://github.com/laravel/breeze/compare/v1.1.8...v1.2.0)

### Added

- React installation option ([#73](https://github.com/laravel/breeze/pull/73))
- Use new `Password::defaults()` feature ([#71](https://github.com/laravel/breeze/pull/71))

## [v1.1.8 (2021-05-18)](https://github.com/laravel/breeze/compare/v1.1.7...v1.1.8)

### Fixed

- Bump Inertia version to match Spark ([#70](https://github.com/laravel/breeze/pull/70))

## [v1.1.7 (2021-05-11)](https://github.com/laravel/breeze/compare/v1.1.6...v1.1.7)

### Changed

- Uses password rule by default ([#65](https://github.com/laravel/breeze/pull/65))

### Fixed

- Use boolean() instead of filled() ([#68](https://github.com/laravel/breeze/pull/68))
- Fix create method docblock return value ([#69](https://github.com/laravel/breeze/pull/69))

## [v1.1.6 (2021-04-27)](https://github.com/laravel/breeze/compare/v1.1.5...v1.1.6)

### Fixed

- Fix Vue warning ([#62](https://github.com/laravel/breeze/pull/62))

## [v1.1.5 (2021-04-13)](https://github.com/laravel/breeze/compare/v1.1.4...v1.1.5)

### Fixed

- Fix Login event firing before Register ([#59](https://github.com/laravel/breeze/pull/59))

## [v1.1.4 (2021-03-23)](https://github.com/laravel/breeze/compare/v1.1.3...v1.1.4)

### Fixed

- Fixes Vue warning ([#55](https://github.com/laravel/breeze/pull/55))

### Removed

- Remove unused component ([#54](https://github.com/laravel/breeze/pull/54))

## [v1.1.3 (2021-02-18)](https://github.com/laravel/breeze/compare/v1.1.2...v1.1.3)

### Fixed

- Update stubs/inertia/app case in installInertiaStack ([#53](https://github.com/laravel/breeze/pull/53))

## [v1.1.2 (2021-02-18)](https://github.com/laravel/breeze/compare/v1.1.1...v1.1.2)

### Changed

- Add `@inertiajs/progress` to package dependencies ([#46](https://github.com/laravel/breeze/pull/46), [#49](https://github.com/laravel/breeze/pull/49))
- Reduce verbosity by introducing a 'Guest' layout ([#52](https://github.com/laravel/breeze/pull/52))
- Add email (username) autocomplete ([#51](https://github.com/laravel/breeze/pull/51))
- Simplify Inertia logout links ([#48](https://github.com/laravel/breeze/pull/48))

## [v1.1.1 (2021-02-17)](https://github.com/laravel/breeze/compare/v1.0.4...v1.1.1)

### Added

- Inertia Stack ([#44)](https://github.com/laravel/breeze/pull/44))

### Fixed

- Copy webpack.config.js on inertia init ([#45](https://github.com/laravel/breeze/pull/45))

## [v1.0.4 (2021-02-16)](https://github.com/laravel/breeze/compare/v1.0.3...v1.0.4)

### Changed

- Update Tailwind config ([de0cbf4](https://github.com/laravel/breeze/commit/de0cbf49b50c22aaf047dcaba8c83827164ff668))

## [v1.0.3 (2021-02-16)](https://github.com/laravel/breeze/compare/v1.0.2...v1.0.3)

### Fixed

- Redirect to intended path after login ([#39](https://github.com/laravel/breeze/pull/39))
- Change "Logout" text to "Log out" and "Login" to "Log in" ([#41](https://github.com/laravel/breeze/pull/41))

## [v1.0.2 (2021-01-05)](https://github.com/laravel/breeze/compare/v1.0.1...v1.0.2)

### Changed

- Upgrade to PostCSS 8 as Laravel Mix v6 is out ([#31](https://github.com/laravel/breeze/pull/31))

## [v1.0.1 (2020-12-22)](https://github.com/laravel/breeze/compare/v1.0.0...v1.0.1)

### Changed

- Reuse blade component ([#30](https://github.com/laravel/breeze/pull/30))
- Improve SPA compatibility ([#29](https://github.com/laravel/breeze/pull/29))

## v1.0.0 (2020-10-08)

Initial stable release.
