<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ config('app.name', '') }} </title>
    <!-- Scripts -->
    @vite(['resources/sass/app.scss', 'resources/js/app.js'])
</head>

<body class="font-sans antialiased bg-light">
    <header class="p-4 w-100 text-body-secondary mb-3 d-none d-lg-block">
        @if (Route::has('login'))
            <nav class="d-flex align-items-center justify-content-end gap-2">
                @auth
                    <a href="{{ url('/dashboard') }}" class="btn btn-outline-secondary btn-sm">
                        Dashboard
                    </a>
                @else
                    <a href="{{ route('login') }}" class="btn btn-outline-secondary btn-sm">
                        Log in
                    </a>
                    @if (Route::has('register'))
                        <a href="{{ route('register') }}" class="btn btn-outline-secondary btn-sm">
                            Register
                        </a>
                    @endif
                @endauth
            </nav>
        @endif
    </header>
    <div class="text-dark d-flex p-3 p-lg-4 align-items-center justify-content-center flex-column">
        <main class="text-center">
            <h1>Welcome to Laravel</h1>
            <p class="lead">This is a basic homepage for your Laravel application.</p>
        </main>
        @if (Route::has('login'))
            <div class="d-none d-lg-block" style="height: 58px;"></div>
        @endif
    </div>
</body>

</html>
