<?php

namespace Wizard\Framework\Traits;

trait Filterable
{
    protected static $filters = [];

    // End goal: 'column_name' 'operator' 'value'
    // string:   name LIKE '%test%'
    // value:    id = 3
    // date:
    //
    //
    // table
    // column
    // operator ? based on the value?
    // value
    // required joins
    //

    public function scopeFilter($query, $validated)
    {
        $filters = static::$filters;

        foreach ($filters as $key => $filter) {

            if (isset($validated[$key])) {
                if (isset($filter['callback'])) {

                } else {
                    switch ($filter['type']) {
                        case 'value':
                        default:
                            $this->valueFilter($query, $filter, $validated[$key]);
                    }
                }
            }
        }
    }

    public function valueFilter($query, $filter, $value)
    {
        $query->where($filter['table'].'.'.$filter['column_name'], '=', $value);
    }

    // filter for dates
    public function dateFilter() {}
}
