@props(['name', 'label', 'value' => '', 'required' => false])

<div class="mb-3">
    <label for="{{ $name }}" class="form-label">
        {{ $label }}
        @if($required)
            <span class="text-danger">*</span>
        @endif
    </label>

    <textarea 
        name="{{ $name }}" 
        id="{{ $name }}" 
        @if ($required) required @endif
        class="markdown-editor form-control"
    >{{ old($name, $value) }}</textarea>

    @error($name)
        <div class="text-danger small">{{ $message }}</div>
    @enderror
</div>
@include('includes.easymde')
