<?php

namespace Wizard\Framework\Database;

use Illuminate\Database\Schema\Builder;
use Illuminate\Support\Facades\Schema as BaseSchema;

class MySchema extends BaseSchema
{
    /**
     * Get a schema builder instance for a connection.
     *
     * @param  string|null  $name
     */
    public static function connection($name): Builder
    {
        return self::customizedSchemaBuilder($name);
    }

    /**
     * Retrieves an instance of the schema `Builder` with a customized `Blueprint` class.
     */
    public static function customizedSchemaBuilder(?string $name = null): Builder
    {
        /** @var Builder $builder */
        $builder = static::$app['db']->connection($name)->getSchemaBuilder();

        $builder->blueprintResolver(static fn ($table, $callback, $prefix) => new MyBlueprint($table, $callback, $prefix));

        return $builder;
    }
}
