@props(['name', 'label', 'checked' => false])

<div class="mb-4 flex items-center">
    <input type="checkbox" id="{{ $name }}" name="{{ $name }}" value="1"
        {{ old($name, $checked) ? 'checked' : '' }}
        class="rounded border-gray-300 text-blue-600 shadow-sm focus:ring-blue-200">
    <label for="{{ $name }}" class="ml-2 text-gray-700">{{ $label }}</label>
    @error($name)
        <span class="text-red-600 text-sm">{{ $message }}</span>
    @enderror
</div>
