@props(['name', 'label', 'value' => '', 'required' => false])

<div class="mb-4">
    <label for="{{ $name }}" class="block text-gray-700 font-medium mb-1">
        {{ $label }}
        @if($required)
            <span class="text-red-500">*</span>
        @endif
    </label>

    <textarea 
        name="{{ $name }}" 
        id="{{ $name }}" 
        @if ($required) required @endif
        class="markdown-editor mt-1 block w-full rounded border-gray-300 shadow-sm focus:ring focus:ring-blue-200"
    >{{ old($name, $value) }}</textarea>

    @error($name)
        <span class="text-red-600 text-sm">{{ $message }}</span>
    @enderror
</div>
@include('includes.easymde')
