<?php

namespace Wizard\Framework\Database;

use Illuminate\Database\Eloquent\Builder as BaseBuilder;

class Builder extends BaseBuilder {
	
	public $named_joins = [];

	/*
	 * Add's a named join to the query, this will only add the joins
	 * a single time, and keep track of joins that are already in the query.
	 *
	 */
	public function addNamedJoin($join = '') {
		$available_joins = $this->model?->named_joins() ?? [];
		if(isset($available_joins[$join]) && ($named_joins[$join] ?? false) == false) {
			$this->named_joins[$join] = true;
			$available_joins[$join]($this);
		}
	}
}
