<?php

namespace Wizard\Framework;

use Illuminate\Support\ServiceProvider;

class FrameworkServiceProvider extends ServiceProvider {
	public function register():void
 	{
		$this->app->bind('db.schema', fn () => \Libraries\MySchema::customizedSchemaBuilder()); 
	}

	public function boot(): void {
		$publish_path = __DIR__.'/../publishable';
		$this->publishes([
			$publish_path.'/resources/views/components' => resource_path('views/components'),
			$publish_path.'/vite.config.js' => base_path(),
		]);

		foreach (glob(base_path('routes/resources/*.php')) as $routeFile) {
            $this->loadRoutesFrom($routeFile);
     }

	}
}
