@props([
    'title' => null, // e.g. 'Upcoming Milestones'
    'icon' => null, // SVG (pass as a Blade include or html)
    'empty' => 'Nothing to show.',
    'footer' => null, // Optional (e.g. a "View All" link)
    'headerButton' => null, //button or link for the right side of the header
])

<div class="bg-white p-4 rounded-lg shadow min-h-[200px]">
    <div class="flex justify-between items-center">
        <h4 class="font-semibold text-gray-800 mb-3 flex items-center">
            {!! $icon ?? '' !!}
            <span class="ml-2">{{ $title }}</span>
        </h4>
        {!! $headerButton !!}
    </div>
    {{ $slot }}
    @if ($footer)
        <div class="text-right mt-3">
            {!! $footer !!}
        </div>
    @endif
</div>
