@props([
    'title', // e.g. 'Upcoming Milestones'
    'icon', // SVG (pass as a Blade include or html)
    'items', // Collection of items to show
    'itemView', // Partial for rendering each item
    'viewData' => [], // Additional data to pass to the partial
    'empty' => 'Nothing to show.',
    'footer' => null, // Optional (e.g. a "View All" link)
    'headerButton' => null, // Optional (e.g. a "Add" link)
])

<x-card :icon="$icon" :title="$title" :headerButton="$headerButton" :footer="$footer">
    @if ($items->count())
        <ul class="divide-y divide-gray-100">
            @foreach ($items as $item)
                @include($itemView, array_merge(['item' => $item], $viewData ?? []))
            @endforeach
        </ul>
    @else
        <div class="text-gray-400 text-sm">{{ $empty }}</div>
    @endif
</x-card>
