import { defineConfig } from "vite";
import laravel from "laravel-vite-plugin";
import prism from 'vite-plugin-prismjs';
import fs from "fs";
import path from "path";

const pagesDir = "resources/js/pages";
const pageScripts = fs
    .readdirSync(pagesDir)
    .map((file) => path.join(pagesDir, file));

export default defineConfig({
 // Optional: Silence Sass deprecation warnings. See note below.
  css: {
     preprocessorOptions: {
        scss: {
          silenceDeprecations: [
            'import',
            'mixed-decls',
            'color-functions',
            'global-builtin',
          ],
        },
     },
  },
    plugins: [
        laravel({
            input: [
                "resources/css/app.css",
                "resources/js/app.js",
                "resources/js/easymde.js",
                "resources/js/prismjs.js",
                ...pageScripts,
            ],
            refresh: true,
        }),
        prism({
            languages: ["javascript", "css", "html", "typescript", "php", "sql", "bash", "sh"],
            plugins: ["line-numbers"],
            theme: "tomorrow",
            css: true,
        }),
    ],
});
