@props([
    'icon', // SVG icon as a Blade include or HTML
    'title',
    'value',
    'subtitle' => '',
    'color' => 'blue', // For icon background
])

@php
    $bgColor =
        [
            'green' => 'bg-green-100 text-green-600',
            'blue' => 'bg-blue-100 text-blue-600',
            'purple' => 'bg-purple-100 text-purple-600',
            'yellow' => 'bg-yellow-100 text-yellow-600',
            'gray' => 'bg-gray-100 text-gray-600',
        ][$color] ?? 'bg-blue-100 text-blue-600';
@endphp

<div class="flex items-center bg-white rounded-lg shadow p-4 min-w-[170px]">
    <div class="flex-shrink-0">
        <span class="inline-flex items-center justify-center h-12 w-12 rounded-full {{ $bgColor }}">
            {!! $icon !!}
        </span>
    </div>
    <div class="ml-4">
        <div class="text-lg font-semibold text-gray-900">{{ $value }}</div>
        <div class="text-gray-500">{{ $title }}</div>
        @if ($subtitle)
            <div class="text-xs text-gray-400 mt-1">{{ $subtitle }}</div>
        @endif
    </div>
</div>
