@props(['name', 'label', 'options' => [], 'value' => '', 'required' => false])
<div class="mb-4">
    <label for="{{ $name }}" class="block text-gray-700">{{ $label }}</label>
    <select name="{{ $name }}" id="{{ $name }}" @if ($required) required @endif
        class="mt-1 block w-full rounded border-gray-300 shadow-sm focus:ring focus:ring-blue-200">
        <option value="">Select...</option>
        @foreach ($options as $optionValue => $optionLabel)
            <option value="{{ $optionValue }}" {{ old($name, $value) == $optionValue ? 'selected' : '' }}>
                {{ $optionLabel }}
            </option>
        @endforeach
    </select>
    @error($name)
        <span class="text-red-600 text-sm">{{ $message }}</span>
    @enderror
</div>
