@props([
    'icon', // SVG icon as a Blade include or HTML
    'title',
    'value',
    'subtitle' => '',
    'color' => 'blue', // For icon background
])

@php
    $bgColor =
        [
            'green' => 'green',
            'blue' => 'blue',
            'purple' => 'purple',
            'yellow' => 'yellow',
            'gray' => 'gray',
        ][$color] ?? 'blue';
@endphp

<div class="dashboard-card">
    <div class="d-flex-shrink-0">
        <span class="inline-flex icon items-center justify-center h-12 w-12 rounded-full {{ $bgColor }}">
            {!! $icon !!}
        </span>
    </div>
    <div class="ml-4">
        <div class="fs-4 fw-medium">{{ $value }}</div>
        <div class="fs-5 fw-medium text-secondary">{{ $title }}</div>
        @if ($subtitle)
            <div class="fs-6 text-secondary">{{ $subtitle }}</div>
        @endif
    </div>
</div>
