@props([
    'title', // e.g. 'Upcoming Milestones'
    'icon', // SVG (pass as a Blade include or html)
    'items', // Collection of items to show
    'itemView', // Partial for rendering each item
    'viewData' => [], // Additional data to pass to the partial
    'empty' => 'Nothing to show.',
    'footer' => null, // Optional (e.g. a "View All" link)
    'headerButton' => null, // Optional (e.g. a "Add" link)
])

{{-- <x-card :icon="$icon" :title="$title" :headerButton="$headerButton" :footer="$footer"> --}}
<div class="dashboard-card flex-column align-items-stretch">
    <div class="d-flex justify-content-between">
        <h4 class=" items-center align-content-start">
            {!! $icon ?? '' !!}
            <span class="ml-2">{{ $title }}</span>
        </h4>
        {!! $headerButton !!}
    </div>
    <div class="card-body">
        @if ($items->count())
            <ul class="px-1">
                @foreach ($items as $item)
                    @include($itemView, array_merge(['item' => $item], $viewData ?? []))
                @endforeach
            </ul>
        @else
            <div class="text-gray-400 text-sm">{{ $empty }}</div>
        @endif
    </div>
    @if ($footer)
        <div class="text-right mt-3">
            {!! $footer !!}
        </div>
    @endif
</div>
