<?php

namespace Wizard\Framework;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;
use \Wizard\Framework\Database\MySchema;

class FrameworkServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        $this->app->bind('db.schema', fn () => MySchema::customizedSchemaBuilder());
    }

    public function boot(): void
    {
        $publish_path = __DIR__.'/../publishable';
        $this->publishes([
            $publish_path.'/resources' => resource_path(),
            $publish_path.'/vite.config.js' => base_path('vite.config.js'),
            $publish_path.'/package.json' => base_path('package.json'),
            $publish_path.'/stubs' => base_path('stubs'),
        ]);

        foreach (glob(base_path('routes/resources/*.php')) as $routeFile) {
            $this->loadRoutesFrom($routeFile);
        }

    }
}
