<?php

namespace Wizard\Framework\Traits;

trait Filterable
{
    protected static $filters = [];

    public function scopeFilter($query, $validated)
    {
        $filters = static::$filters;

        foreach ($filters as $key => $filter) {

            if (isset($validated[$key])) {
                if (isset($filter['callback'])) {

                } else {
                    switch ($filter['type']) {
                        case 'value':
                        default:
                            $this->valueFilter($query, $filter, $validated[$key]);
                    }
                }
            }
        }
    }

    public function valueFilter($query, $filter, $value)
    {
        $query->where($filter['table'].'.'.$filter['column_name'], '=', $value);
    }

    // filter for dates
    public function dateFilter() {}
}
