<?php

namespace Wizard\MagicForger\Generator\View;

use Symfony\Component\Console\Attribute\AsCommand;
use Wizard\MagicForger\Generator\BaseGenerator;
use Wizard\MagicForger\Helpers\RelationshipNavigator;
use Illuminate\Support\Str;

#[AsCommand(name: 'mf:create_edit_view')]
class CreateEditViewGenerator extends BaseGenerator
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $name = 'mf:create_edit_view';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generates the CreateEditView File for a table.';

    /**
     * The type of class being generated.
     *
     * @var string
     */
    protected $type = 'CreateEditView';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        parent::handle();
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub()
    {
        return $this->resolveStubPath('/stubs/create_edit.stub');
    }

    /**
     * Resolve the fully-qualified path to the stub.
     *
     * @param  string  $stub
     * @return string
     */
    protected function resolveStubPath($stub)
    {
        return is_file($customPath = $this->laravel->basePath(trim($stub, '/')))
            ? $customPath
            : __DIR__.$stub;
    }

    protected function getClassName($name)
    {
        return $this->create_edit_view_name($name);
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getPath($name = null)
    {
        return str_replace(['Resources\\', '\\'], ['resources/', '/'], $this->getViewNamespace($this->getTableInput()).'create_edit.blade.php');
    }

		protected function renderColumns() {
				$renders = [];

				$columns = $this->getTableColumns($this->getCurrentTable());
        $relations = RelationshipNavigator::getRelations($this->getCurrentTable());
				//gether the select columns based on the relations
				$selects = [];

				foreach($relations['belongsTo'] as $relation) {
					$selects[$relation['column']] = $relation['table'];
				}

				foreach($columns as $column) {
					$name = $column['name'];
					if(in_array($name, $this->columns_to_ignore)) continue;

					$type = $column['type_name'];

					$replacements = [
						'{{fieldName}}' => $name,
						'{{fieldLabel}}' => Str::headline($name),
						'{{required}}' => $column['nullable'] ? 'false' : 'true',
					];
					$snippet = '';

					//date
					if(in_array($type, ['date', 'timestamp'])) {
						$snippet = $this->getSnippet('input/date');	
					}
					//checkbox
					elseif(in_array($type, ['tinyint']) && array_key_exists($name, $selects)) {
						$snippet = $this->getSnippet('input/checkbox');	
					}

					//select
					elseif(in_array($type, ['bigint']) && array_key_exists($name, $selects)) {
						$snippet = $this->getSnippet('input/select');	
						$replacements['{{fieldLabel}}'] = Str::headline(Str::singular($selects[$name]));
						$replacements['{{options}}'] = '$'.$selects[$name];
					}

					//text area
					elseif(in_array($type, ['text'])) {
						$snippet = $this->getSnippet('input/textarea');	
					}
					else {
						//varchar, bigint, float, etc
						$snippet = $this->getSnippet('input/text');	
					}


					// Replace placeholders with actual values
        	$renders[] = str_replace(
							array_keys($replacements),
							$replacements,
        	    $snippet
        	);
				}
			return $renders;
		}

		

    /**
     * Get available insertions including model relationships.
     *
     * @return array
     */
    public function get_available_inserts(): array
    {
        // Merge parent insertions (attributes, fillable, etc.)
        $inserts = parent::get_available_inserts();

        // Gather and render relationships for this model
        $rendered = $this->renderColumns();

        // Build code blocks for each relation type
        $columns = !empty($rendered) ? implode("\n    ", $rendered) : '';

        // Assign to stub placeholders
        $inserts['{{ fieldsInsertPoint }}'] = $columns;

        return $inserts;
    }
}
