<?php

namespace Wizard\MagicForger\Generator\View;

use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Wizard\MagicForger\Generator\BaseGenerator;

#[AsCommand(name: 'mf:view')]
class ViewGenerator extends BaseGenerator
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $name = 'mf:view';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generates the View File for a table.';

    /**
     * The type of class being generated.
     *
     * @var string
     */
    protected $type = 'View';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // First we need to ensure that the table exists, then we can
        if (! $this->tableExists($this->getTableInput())) {
            $this->components->error('The table: "'.$this->getTableInput().'" does not exist in the database.');

            return false;
        }

        if ($this->option('all')) {
            $this->input->setOption('index_view', true);
            $this->input->setOption('create_edit_view', true);
            $this->input->setOption('show_view', true);
        }

        if ($this->option('index_view')) {
            $this->createIndexView();
        }

        if ($this->option('create_edit_view')) {
            $this->createCreateEditView();
        }

        if ($this->option('show_view')) {
            $this->createShowView();
        }
    }

    /**
     * Get the console command options.
     */
    protected function getOptions(): array
    {
        return array_merge(parent::getOptions(), [
            ['all', 'a', InputOption::VALUE_NONE, 'Generate all views for the table.'],
            ['index_view', 'i', InputOption::VALUE_NONE, 'Generate index view for the table.'],
            ['create_edit_view', 'c', InputOption::VALUE_NONE, 'Generate create_edit view for the table.'],
            ['show_view', 's', InputOption::VALUE_NONE, 'Generate show view for the table.'],
        ]);
    }

    /**
     * Interact further with the user if they were prompted for missing arguments.
     */
    protected function afterPromptingForMissingArguments(InputInterface $input, OutputInterface $output): void {}

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub() {}

    protected function createIndexView()
    {
        $this->call('mf:index_view', ['table' => $this->getTableInput()]);
    }

    protected function createCreateEditView()
    {
        $this->call('mf:create_edit_view', ['table' => $this->getTableInput()]);
    }

    protected function createShowView()
    {
        $this->call('mf:show_view', ['table' => $this->getTableInput()]);
    }
}
