<?php

namespace Wizzard\Magicforger\BlueprintExtensions;

use Illuminate\Database\Schema\Blueprint;

class CustomBlueprint extends Blueprint
{
    /**
     * Create columns for the table that should be in every table.
     *
     * @return void
     */
    public function defaultColumns()
    {
        $this->timestamps();
				$this->reference("users", "created_by");
				$this->reference("users", "updated_by");
        $this->softDeletes();
    }


		public function reference($table_name, $column_name)
		{
		    // check if the table exists before creating the reference
		    if (!Schema::hasTable($table_name)) {
		        throw new Exception("Table $table_name does not exist.");
		    }

				$reference_column_name = $column_name ?? ($table_name . '_id');
		
		    $reference_column = $table->unsignedBigInteger($reference_column_name);
		    $table->foreign($reference_column_name)->references('id')->on($table_name);

				return $reference_column;
		}

}
