<?php

namespace Wizzard\MagicForger\Generator\Requests;

use Symfony\Component\Console\Attribute\AsCommand;
use Wizzard\MagicForger\Generator\BaseGenerator;

#[AsCommand(name: 'mf:update_request')]
class UpdateRequestGenerator extends BaseGenerator
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $name = 'mf:update_request';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generates the UpdateRequest File for a table.';

    /**
     * The type of class being generated.
     *
     * @var string
     */
    protected $type = 'UpdateRequest';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        parent::handle();
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub()
    {
        return $this->resolveStubPath('/stubs/request.stub');
    }

    /**
     * Resolve the fully-qualified path to the stub.
     *
     * @param string $stub
     *
     * @return string
     */
    protected function resolveStubPath($stub)
    {
        return is_file($customPath = $this->laravel->basePath(trim($stub, '/')))
            ? $customPath
            : __DIR__.$stub;
    }

    protected function getClassName($name)
    {
        return $this->update_request_name($name);
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getPath($name = null)
    {
        return str_replace(['App\\', '\\'], ['app/', '/'], $this->getRequestNamespace($this->getTableInput()).'/'.$this->update_request_name($this->getTableInput()).'.php');
    }
}
