<?php

namespace Wizzard\MagicForger\Generator;

use DB;

use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Illuminate\Support\Str;

use Wizzard\MagicForger\Generator\BaseGenerator;
use Wizzard\MagicForger\Replacer;

#[AsCommand(name: 'mf')]
class Generator extends BaseGenerator
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $name = 'mf';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generates any (or all) of the available files.';


    /**
     * Execute the console command.
     */
    public function handle()
    {

        // First we need to ensure that the table exists, then we can
        if (!$this->tableExists($this->getTableInput())) {
            $this->components->error('The table: "'.$this->getTableInput().'" does not exist in the database.');

            return false;
        }

        if ($this->option('all')) {
            /* $this->input->setOption('factory', true); */
            /* $this->input->setOption('seed', true); */
            /* $this->input->setOption('migration', true); */
            $this->input->setOption('controller', true);
            /* $this->input->setOption('model', true); */
        }

        /* if ($this->option('factory')) { */
        /*     $this->createFactory(); */
        /* } */

        /* if ($this->option('migration')) { */
        /*     $this->createMigration(); */
        /* } */

        /* if ($this->option('seed')) { */
        /*     $this->createSeeder(); */
        /* } */

        if ($this->option('controller')) {
            $this->createController();
        }

        /* if ($this->option('model')) { */
        /*     $this->createModel(); */
        /* } */

    }

    /**
     * Get the console command options.
     *
     * @return array
     */
    protected function getOptions()
    {
        return [
            ['all', 'a', InputOption::VALUE_NONE, 'Generate a migration, seeder, factory, policy, resource controller, and form request classes for the table.'],
            ['controller', 'c', InputOption::VALUE_NONE, 'Generate a controller class for the table.'],
        ];
    }

    /**
     * Interact further with the user if they were prompted for missing arguments.
     *
     * @return void
     */
    protected function afterPromptingForMissingArguments(InputInterface $input, OutputInterface $output)
    {
    }

    protected function getStub()
    {
    }

    protected function createController()
    {
        $this->call('mf:controller', ['table' => $this->getTableInput()]);
    }
}
