<?php

namespace Wizzard\MagicForger;

use Illuminate\Support\Str;

class Replacer
{
    /**
     * Cached replacements for re-use.
     *
     * @var array
     */
    protected $replacement_cache = [];




    /**
     * The lowest level to show log outputs.
     *
     * @var int
     */
    private $log_level = 1;


    public function __construct()
    {
        /* parent::__construct(); */
    }


    /**
     * Outputs a log for the replacements based on log level.
     */
    public function log(string $str, int $log_level = 1): void
    {

        if($this->log_level <= $log_level) {
            print($str . "\n");
        }

    }
}
