<?php

namespace Wizzard\MagicForger\Generator\Controller;

use Symfony\Component\Console\Attribute\AsCommand;
use Wizzard\MagicForger\Generator\BaseGenerator;
use Wizzard\MagicForger\Replacer;
use Illuminate\Support\Str;

//use Illuminate\Console\Concerns\CreatesMatchingTest;

#[AsCommand(name: 'mf:controller')]
class ControllerGenerator extends BaseGenerator
{
    //use CreatesMatchingTest;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $name = 'mf:controller';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generates the Controller File for a table.';

    /**
     * The type of class being generated.
     *
     * @var string
     */
    protected $type = 'Controller';


    /**
     * Execute the console command.
     */
    public function handle()
    {


        // First we need to ensure that the table exists, then we can
        if (! $this->tableExists($this->getTableInput())) {
            $this->components->error('The table: "'.$this->getTableInput().'" does not exist in the database.');

            return false;
        }

        $name = $this->qualifyClass($this->getTableInput());

        $path = $this->getPath($name);

        $file = $this->getFile($path);

        $file = $this->apply_replacements($file);


        // Next, we will generate the path to the location where this class' file should get
        // written. Then, we will build the class and make the proper replacements on the
        // file so that it gets the correctly formatted namespace and class name.
        $path = $this->makeDirectory($path);

        $this->files->put($path, $this->sortImports($file));

        $info = $this->type;

        if (in_array(CreatesMatchingTest::class, class_uses_recursive($this))) {
            if ($this->handleTestCreation($path)) {
                $info .= ' and test';
            }
        }

        $this->components->info(sprintf('%s [%s] created successfully.', $info, $path));
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub()
    {
        return $this->resolveStubPath('/stubs/controller.stub');
    }

    /**
     * Resolve the fully-qualified path to the stub.
     *
     * @param  string  $stub
     * @return string
     */
    protected function resolveStubPath($stub)
    {
        return is_file($customPath = $this->laravel->basePath(trim($stub, '/')))
            ? $customPath
            : __DIR__.$stub;
    }
    /**
     * Parse the class name and format according to the root namespace.
     *
     * @param  string  $name
     * @return string
     */
    protected function qualifyClass($name)
    {
        $name = ltrim($name, '\\/');

        $name = str_replace('/', '\\', $name);

        $rootNamespace = $this->rootNamespace();

        if (Str::startsWith($name, $rootNamespace)) {
            return $name;
        }

        return $this->qualifyClass(
            $this->getDefaultNamespace(trim($rootNamespace, '\\')).'\\'.$name
        );
    }

    protected function getClassName($name)
    {
        return $this->controller_name($name);
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getPath($name)
    {
        return str_replace(['App\\', '\\'], ['app/', '/'], $this->getControllerNamespace() . '/' . $this->controller_name($this->getTableInput()) . '.php');
    }
}
