<?php

namespace Wizard\MagicForger\Generator\View;

use Symfony\Component\Console\Attribute\AsCommand;
use Wizard\MagicForger\Helpers\RelationshipNavigator;
use Wizard\MagicForger\Generator\BaseGenerator;
use Illuminate\Support\Str;

#[AsCommand(name: 'mf:index_view')]
class IndexViewGenerator extends BaseGenerator
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $name = 'mf:index_view';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generates the IndexView File for a table.';

    /**
     * The type of class being generated.
     *
     * @var string
     */
    protected $type = 'IndexView';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        parent::handle();
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub()
    {
        return $this->resolveStubPath('/stubs/index.stub');
    }

    /**
     * Resolve the fully-qualified path to the stub.
     *
     * @param  string  $stub
     * @return string
     */
    protected function resolveStubPath($stub)
    {
        return is_file($customPath = $this->laravel->basePath(trim($stub, '/')))
            ? $customPath
            : __DIR__.$stub;
    }

    protected function getClassName($name)
    {
        return $this->index_view_name($name);
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getPath($name = null)
    {
        return str_replace(['Resources\\', '\\'], ['resources/', '/'], $this->getViewNamespace($this->getTableInput()).'index.blade.php');
    }
		

		protected function renderColumns() {
				$renders = [];
				$headers = [];
				$values = [];
				$colCount = 0;

				$columns = $this->getTableColumns($this->getCurrentTable());
        $relations = RelationshipNavigator::getRelations($this->getCurrentTable());
				//gether the select columns based on the relations
				$selects = [];

				foreach($relations['belongsTo'] as $relation) {
					$selects[$relation['column']] = $relation['table'];
				}

				foreach($columns as $column) {
					$name = $column['name'];
					if(in_array($name, $this->columns_to_ignore)) continue;


					//Get the expected header name
					$replacements = [
						'{{header}}' => Str::headline($name),
						'{{headerClass}}' => 'p-2',
						'{{value}}' => '{{ $item->' . $name . ' ?? "" }}',
						'{{valueClass}}' => 'p-2',
					];

					$type = $column['type_name'];


					//date
					if(in_array($type, ['date'])) {
						$replacements['{{value}}'] = '{{ $item->'.$name.'?->format(\'Y-m-d\') ?? "" }}';
					}
					//time
					if(in_array($type, ['timestamp'])) {
						$replacements['{{value}}'] = '{{ $item->'.$name.'?->format(\'Y-m-d H:i\') ?? "" }}';
					}
					//checkbox
					if(in_array($type, ['tinyint'])) {
						$replacements['{{valueClass}}'] .= ' text-center';
						$replacements['{{value}}'] = '{{ $item->' . $name . ' ?? "0" }}';
					}
					//select
					elseif(in_array($type, ['bigint']) && array_key_exists($name, $selects)) {
						$replacements['{{header}}'] = Str::headline(Str::singular($selects[$name]));
						$replacements['{{value}}'] = '{{ $item->'.Str::singular($selects[$name]) . '?->name ?? "" }}';
					}
					// bigint, float
					elseif(in_array($type, ['bigint', 'float', 'int'])) {
						$replacements['{{valueClass}}'] .= ' text-start';
					}
					else {
						//text area
						//varchar, , etc
					}

					$snippet = $this->getSnippet('index/value');	
					// Replace placeholders with actual values
        	$values[] = str_replace(
							array_keys($replacements),
							$replacements,
        	    $snippet
        	);

					$snippet = $this->getSnippet('index/header');	
					// Replace placeholders with actual values
        	$headers[] = str_replace(
							array_keys($replacements),
							$replacements,
        	    $snippet
        	);
					$colCount++;
				}

			return ['headers' => $headers, 'values' => $values, 'colCount' => $colCount];
		}

    /**
     * Get available insertions including model relationships.
     *
     * @return array
     */
    public function get_available_inserts(): array
    {
        // Merge parent insertions (attributes, fillable, etc.)
        $inserts = parent::get_available_inserts();

        // Gather and render relationships for this model
        $rendered = $this->renderColumns();

        // Build code blocks for each relation type
				$headers = '';
				$values = '';
				$colCount = '';
				
				if(!empty($rendered)) {
					$headers = !empty($rendered['headers']) ? implode("\n    ", $rendered['headers']) : '';
					$values = !empty($rendered['values']) ? implode("\n    ", $rendered['values']) : '';
					$colCount = isset($rendered['colCount']) ? $rendered['colCount'] : '';
				}

        // Assign to stub placeholders
        $inserts['{{ headerInsertPoint }}'] = $headers;
        $inserts['{{ valueInsertPoint }}'] = $values;
        $inserts['{{ colCount }}'] = $colCount;

        return $inserts;
    }
}
