<?php

namespace Wizzard\MagicForger;

use Illuminate\Support\ServiceProvider;
use Wizzard\MagicForger\Generator\Generator;
use Wizzard\MagicForger\Generator\Controller\ControllerGenerator;
use Wizzard\MagicForger\Generator\Model\ModelGenerator;
use Wizzard\MagicForger\Generator\Requests\RequestGenerator;
use Wizzard\MagicForger\Generator\Requests\StoreRequestGenerator;
use Wizzard\MagicForger\Generator\Requests\UpdateRequestGenerator;
use Wizzard\MagicForger\Generator\Route\RouteGenerator;

class MagicForgerServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any package services.
     */
    public function boot(): void
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                Generator::class,
                ControllerGenerator::class,
                ModelGenerator::class,
                RequestGenerator::class,
                StoreRequestGenerator::class,
                UpdateRequestGenerator::class,
                RouteGenerator::class,
            ]);
        }
    }
}
