<?php

namespace Wizzard\MagicForger\Generator;

use DB;

use Illuminate\Routing\Console\ControllerMakeCommand;

use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

use Wizzard\MagicForger\Replacer;

#[AsCommand(name: 'mf')]
class BaseGenerator extends ControllerMakeCommand
{
    protected $schema;
		protected $tables;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $name = 'mf';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generates any (or all) of the available files.';

    /**
     * Execute the console command.
     */
    public function handle()
    {

        // First we need to ensure that the table exists, then we can
        if (!$this->tableExists($this->getTableInput())) {
            $this->components->error('The table: "'.$this->getTableInput().'" does not exist in the database.');

            return false;
        }

        if ($this->option('all')) {
            $this->input->setOption('factory', true);
            $this->input->setOption('seed', true);
            $this->input->setOption('migration', true);
            $this->input->setOption('controller', true);
            $this->input->setOption('model', true);
        }

        if ($this->option('factory')) {
            $this->createFactory();
        }

        if ($this->option('migration')) {
            $this->createMigration();
        }

        if ($this->option('seed')) {
            $this->createSeeder();
        }

        if ($this->option('controller')) {
            $this->createController();
        }

        if ($this->option('model')) {
            $this->createModel();
        }

//TODO: when working on an actual 
        $name = $this->qualifyClass($this->getTableInput());

        $path = $this->getPath($name);
				dd($name, $path);

        // Next, We will check to see if the class already exists. If it does, we don't want
        // to create the class and overwrite the user's code. So, we will bail out so the
        // code is untouched. Otherwise, we will continue generating this class' files.
        if ((! $this->hasOption('force') ||
             ! $this->option('force')) &&
             $this->alreadyExists($this->getNameInput())) {
            $this->components->error($this->type.' already exists.');

            return false;
        }

        // Next, we will generate the path to the location where this class' file should get
        // written. Then, we will build the class and make the proper replacements on the
        // stub files so that it gets the correctly formatted namespace and class name.
        $this->makeDirectory($path);

        $this->files->put($path, $this->sortImports($this->buildClass($name)));

        $info = $this->type;

        if (in_array(CreatesMatchingTest::class, class_uses_recursive($this))) {
            if ($this->handleTestCreation($path)) {
                $info .= ' and test';
            }
        }

        $this->components->info(sprintf('%s [%s] created successfully.', $info, $path));
        echo "Generating Replacements\n";
        $replacer = new Replacer();

        $table_name = 'timesheet_statuses';
        $model_name = $replacer->model_name($table_name);
        $controller_name = $replacer->controller_name($table_name);
        $human_readable = $replacer->human_readable($table_name);
        $human_readable_lc = $replacer->human_readable_lc($table_name);
        $replacer->log("Table Name : $table_name");
        $replacer->log("Model Name : $model_name");
        $replacer->log("Controller Name : $controller_name");
        $replacer->log("Human Readable: $human_readable");
        $replacer->log("Human Readable LC: $human_readable_lc");

        echo "Stub Location\n";
        $replacer->log($this->getStub());

    }

    protected function promptForMissingArguments(InputInterface $input, OutputInterface $output)
    {
        $table = null;
        while ($table === null) {
            $table = $this->components->askWithCompletion(
                'What Table should we use?',
                $this->possibleTables()
            );
        }

        $input->setArgument('table', $table);
        parent::promptForMissingArguments($input, $output);
    }

    /**
     * Get the console command arguments.
     *
     * @return array
     */
    protected function getArguments()
    {
        return [
            ['table', InputOption::VALUE_REQUIRED, 'The table to generate files for.'],
        ];
    }

    /**
     * Prompt for missing input arguments using the returned questions.
     *
     * @return array
     */
    protected function promptForMissingArgumentsUsing()
    {
        return [
        ];
    }

    /**
     * Get the console command options.
     *
     * @return array
     */
    protected function getOptions()
    {
        return [
            /* ['type', null, InputOption::VALUE_REQUIRED, 'Manually specify the controller stub file to use'], */
            /* ['force', null, InputOption::VALUE_NONE, 'Create the class even if the controller already exists'], */
            /* ['invokable', 'i', InputOption::VALUE_NONE, 'Generate a single method, invokable controller class'], */

            ['table', null, InputOption::VALUE_REQUIRED, 'The table to generate files for.'],
            ['all', 'a', InputOption::VALUE_NONE, 'Generate a migration, seeder, factory, policy, resource controller, and form request classes for the model'],

        ];
    }

    /**
     * Interact further with the user if they were prompted for missing arguments.
     *
     * @return void
     */
    protected function afterPromptingForMissingArguments(InputInterface $input, OutputInterface $output)
    {
    }

    ////////////////////////////////////////////
    ///				TO GO IN THE BASE CLASS				 ///
    ////////////////////////////////////////////

    /**
     * Get the desired class table from the input.
     *
     * @return string
     */
    protected function getTableInput()
    {
        return trim($this->argument('table'));
    }

    protected function tableExists(string $table_name): bool
    {
        return in_array($table_name, $this->getTables());
    }

    /**
     * Get a list of possible table names.
     */
    protected function possibleTables()
    {

				return $this->getTables();
    }
		
    /**
     * Get the tables in the schema
     */
    protected function getTables()
    {
        $tables = $this->getSchema()->listTableNames();

        return collect($tables)
            ->all();
    }

    /**
     * Get the database schema
     */
    protected function getSchema()
    {
        if (is_null($this->schema)) {
            $this->schema = DB::connection()->getDoctrineSchemaManager();
        }

        return $this->schema;
    }
}
