<?php
namespace Magicforger\Generator;

use Illuminate\Console\GeneratorCommand;
use Symfony\Component\Console\Input\InputOption;

class ControllerGenerator extends GeneratorCommand
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'make:table';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a new controller and views for a table.';

    /**
     * The type of class being generated.
     *
     * @var string
     */
    protected $type = 'Table Controller and Views';

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub()
    {
        // Use your own controller and views stubs here
        return __DIR__ . '/stubs/table.stub';
    }

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        parent::handle();

        $tableName = $this->option('table');

        // Create views directory
        /* $directory = resource_path('views/' . strtolower($tableName)); */
        /* mkdir($directory, 0755, true); */

        /* // Create index view */
        /* $indexViewPath = $directory . '/index.blade.php'; */
        /* file_put_contents($indexViewPath, ''); */

        /* // Create create view */
        /* $createViewPath = $directory . '/create.blade.php'; */
        /* file_put_contents($createViewPath, ''); */

        /* // Create edit view */
        /* $editViewPath = $directory . '/edit.blade.php'; */
        /* file_put_contents($editViewPath, ''); */

        // Success message
				$this->info('Table '. $tableName . ' controller and views created successfully.');
    }

    /**
     * Get the console command options.
     *
     * @return array
     */
    protected function getOptions()
    {
        return [
            ['table', null, InputOption::VALUE_REQUIRED, 'The name of the table.']
        ];
    }
}

