<?php

namespace Wizzard\MagicForger;

use Illuminate\Support\Str;

class Replacer {

    /**
     * Cached replacements for re-use.
     *
     * @var array
     */
	protected $replacement_cache = []; 

		
    /**
	 * Prefix and Suffix for controller.
	 * Usage is up to the user.
     *
     * @var string
     */
	protected $controller_prefix = "";


    /**
	 * Prefix and Suffix for controller.
	 * Usage is up to the user.
     *
     * @var string
     */
	protected $controller_suffix = "Controller";


    /**
	 * The lowest level to show log outputs.
     *
     * @var int
     */
	private $log_level = 1;


	public function __construct() {
		/* parent::__construct(); */
	}

	/**
	 * Model names are generated in uppercase first Camel case 
	 */
	public function model_name(string $name) : string {
		return Str::singular(Str::studly($name));
	}

	/**
	 * Controller names are generated in uppercase first Camel case 
	 * and wrapped in the prefix and suffix
	 */
	public function controller_name(string $name) : string {
		return $this->controller_prefix . 
			$this->model_name($name) .
			$this->controller_suffix;
	}

	/**
	 * Breaks up a string and makes it human readable
	 *
	 * This function assumes that the inputted name is camel case
	 */
	public function human_readable(string $name) : string {
		return Str::title(Str::replace('_', ' ', $name));
	}

	/**
	 * Breaks up a string and makes it human readable and lowecase
	 *
	 * This function assumes that the inputted name is camel case
	 */
	public function human_readable_lc(string $name) : string {
		return Str::lower($this->human_readable($name));
	}

	/**
	 * Outputs a log for the replacements based on log level.
	 */
	public function log(string $str, int $log_level = 1) : void {

		if($this->log_level <= $log_level) {
			print($str . "\n");
		}

	}
}
