<?php
namespace Magicforger/Helpers;


/*
 * Replacer
 *
 * A class that handles all replacements necessary
 *
 * General flow:
 * Read a line looking for a replacement string
 * 
 * A replacement string will consist of 2 values
 * Reference Object, and Replacement Function
 *
 * After the replacement is made, the Object, function
 * are stored in an array to be cached for future replacements
 *
 * Basically lazy loading the replacements.
 * */
class Replacer {


/*
 * The array of cached replacements 
 *
 * Object name => [
 * 	function => replacement text,
 * ]
 *
 * */
protected $replacement_cache [];


/*
 * Static instance of inflector for 
 * string manipulation.
 *
 * */
private static $inflector = null;

public function __construct() {
	if(is_null(self::$inflector)) {
		self::$inflector = InflectorFactory::create()->build();
	}
}




protected function extract_replacement_values(string $replacement_string): string {
	$matches = [];
	preg_match('/o:([^\s]+)\s+f:([^\s]+)/', $replacement_string, $matches);
	$name = $matches[1];
	$function = $matches[2];

	return ['name' => $name, 'function' => $function];
}

protected function get_replacement(string $replacement_string): string {

	


	return $replacement;
}




}
