<?php

namespace Wizard\MagicForger\Generator\Controller;

use Symfony\Component\Console\Attribute\AsCommand;
use Wizard\MagicForger\Generator\BaseGenerator;

#[AsCommand(name: 'mf:controller')]
class ControllerGenerator extends BaseGenerator
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $name = 'mf:controller';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generates the Controller File for a table.';

    /**
     * The type of class being generated.
     *
     * @var string
     */
    protected $type = 'Controller';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle(): void
    {
        parent::handle();
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub(): string
    {
        return $this->resolveStubPath('/stubs/controller.stub');
    }

    /**
     * Resolve the fully-qualified path to the stub.
     *
     * @param string $stub
     * @return string
     */
    protected function resolveStubPath(string $stub): string
    {
        $customPath = $this->laravel->basePath(trim($stub, '/'));

        return is_file($customPath) ? $customPath : __DIR__ . $stub;
    }

    /**
     * Get the path for the generated file.
     */
    protected function getPath($name = null)
    {
        return str_replace(
            ['App\\', '\\'],
            ['app/', '/'],
            $this->getControllerNamespace() . '/' . $this->controller_name($this->getTableInput()) . '.php'
        );
    }

    /**
     * Get the class name for the controller.
     *
     * @param string $name
     * @return string
     */
    protected function getClassName(string $name): string
    {
        return $this->controller_name($name);
    }
}
