<?php

namespace Wizard\MagicForger\Replacer;

trait TableReplacer
{
    protected ?array $columns = null;

    /**
     * Retrieve columns for the current table.
     *
     * @return array
     */
    protected function get_columns(): array
    {
        if (is_null($this->columns)) {
            $this->columns = $this->getCurrentTable()->getColumns();
        }

        return $this->columns;
    }

    /**
     * Get a string representation of values for creation.
     *
     * @return string
     */
    protected function getValuesForCreation(): string
    {
        $insert = '';
        foreach ($this->get_columns() as $column) {
            $insert .= sprintf('$item->%s = $validated["%s"] ?? NULL;', $column->getName(), $column->getName()) . "\n";
        }

        return $insert;
    }

    /**
     * Get a string representation of table attributes.
     *
     * @return string
     */
    protected function getAttributes(): string
    {
        $insert = '';
        foreach ($this->get_columns() as $column) {
            $insert .= sprintf("'%s' => '',", $column->getName()) . "\n";
        }

        return $insert;
    }

    /**
     * Get formatted validation rules for table columns.
     *
     * @return string
     */
    protected function getValuesForValidation(): string
    {
        $insert = '';
        foreach ($this->get_columns() as $column) {
            $insert .= sprintf("'%s' => 'nullable',", $column->getName()) . "\n";
        }

        return $insert;
    }

    /**
     * Apply insertions in the target template.
     *
     * @param string $target
     * @return string
     */
    public function apply_inserts(string $target): string
    {
        $inserts = $this->get_all_keywords($target);
        $available_insertions = $this->get_available_inserts();

        return str_replace(
            array_keys($available_insertions),
            $available_insertions,
            $target
        );
    }

    /**
     * Get available insertion points for the template.
     *
     * @return array
     */
    public function get_available_inserts(): array
    {
        return [
            '// {{ valuesForCreation }}' => $this->getValuesForCreation(),
            '# {{ attributeInsertPoint }}' => $this->getAttributes(),
            '// {{ valuesForValidation }}' => $this->getValuesForValidation(),
        ];
    }
}
