<?php

namespace Wizard\MagicForger;

use Illuminate\Support\ServiceProvider;
use Wizard\MagicForger\Generator\Controller\ControllerGenerator;
use Wizard\MagicForger\Generator\Generator;
use Wizard\MagicForger\Generator\Model\ModelGenerator;
use Wizard\MagicForger\Generator\Requests\RequestGenerator;
use Wizard\MagicForger\Generator\Requests\FilterRequestGenerator;
use Wizard\MagicForger\Generator\Requests\StoreRequestGenerator;
use Wizard\MagicForger\Generator\Requests\UpdateRequestGenerator;
use Wizard\MagicForger\Generator\Route\RouteGenerator;
use Wizard\MagicForger\Generator\View\ViewGenerator;
use Wizard\MagicForger\Generator\View\IndexViewGenerator;
use Wizard\MagicForger\Generator\View\CreateEditViewGenerator;
use Wizard\MagicForger\Generator\View\ShowViewGenerator;

class MagicForgerServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any package services.
     */
    public function boot(): void
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                Generator::class,
                ControllerGenerator::class,
                ModelGenerator::class,
                RequestGenerator::class,
                FilterRequestGenerator::class,
                StoreRequestGenerator::class,
                UpdateRequestGenerator::class,
                RouteGenerator::class,
                ViewGenerator::class,
                IndexViewGenerator::class,
                CreateEditViewGenerator::class,
                ShowViewGenerator::class,
            ]);
        }

        $this->register_config_helper();
    }

    public function register_config_helper()
    {
        ConfigHelper::setup_config_path(base_path());
    }
}
