<?php

namespace Wizard\MagicForger\Generator\Requests;

use Symfony\Component\Console\Attribute\AsCommand;
use Wizard\MagicForger\Generator\BaseGenerator;

#[AsCommand(name: 'mf:filter_request')]
class FilterRequestGenerator extends BaseGenerator
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $name = 'mf:filter_request';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generates the FilterRequest File for a table.';

    /**
     * The type of class being generated.
     *
     * @var string
     */
    protected $type = 'FilterRequest';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        parent::handle();
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub()
    {
        return $this->resolveStubPath('/stubs/request.stub');
    }

    /**
     * Resolve the fully-qualified path to the stub.
     *
     * @param  string  $stub
     * @return string
     */
    protected function resolveStubPath($stub)
    {
        return is_file($customPath = $this->laravel->basePath(trim($stub, '/')))
            ? $customPath
            : __DIR__.$stub;
    }

    protected function getClassName($name)
    {
        return $this->filter_request_name($name);
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getPath($name = null)
    {
        return str_replace(['App\\', '\\'], ['app/', '/'], $this->getRequestNamespace($this->getTableInput()).'/'.$this->filter_request_name($this->getTableInput()).'.php');
    }

    /**
     * Get available insertions including model relationships.
     *
     * @return array
     */
    public function get_available_inserts(): array
    {
        // Merge parent insertions (attributes, fillable, etc.)
        $inserts = parent::get_available_inserts();

		$inserts['// {{ valuesForValidation }}'] = str_replace("'required'", "'nullable'", $inserts['// {{ valuesForValidation }}']);

        return $inserts;
    }
}
