<?php

namespace Wizard\MagicForger\Generator\Requests;

use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Wizard\MagicForger\Generator\BaseGenerator;

#[AsCommand(name: 'mf:request')]
class RequestGenerator extends BaseGenerator
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $name = 'mf:request';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generates the Request File for a table.';

    /**
     * The type of class being generated.
     *
     * @var string
     */
    protected $type = 'Request';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // First we need to ensure that the table exists, then we can
        if (! $this->tableExists($this->getTableInput())) {
            $this->components->error('The table: "'.$this->getTableInput().'" does not exist in the database.');

            return false;
        }

        if ($this->option('all')) {
            $this->input->setOption('store_request', true);
            $this->input->setOption('update_request', true);
        }

        if ($this->option('store_request')) {
            $this->createStoreRequest();
        }

        if ($this->option('update_request')) {
            $this->createUpdateRequest();
        }
    }

    /**
     * Get the console command options.
     */
    protected function getOptions(): array
    {
        return array_merge(parent::getOptions(), [
            ['all', 'a', InputOption::VALUE_NONE, 'Generate all request classes for the table.'],
            ['store_request', 's', InputOption::VALUE_NONE, 'Generate store request class for the table.'],
            ['update_request', 'u', InputOption::VALUE_NONE, 'Generate update request class for the table.'],
        ]);
    }

    /**
     * Interact further with the user if they were prompted for missing arguments.
     */
    protected function afterPromptingForMissingArguments(InputInterface $input, OutputInterface $output): void {}

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub() {}

    protected function createStoreRequest()
    {
        $this->call('mf:store_request', ['table' => $this->getTableInput()]);
    }

    protected function createUpdateRequest()
    {
        $this->call('mf:update_request', ['table' => $this->getTableInput()]);
    }
}
