<?php

namespace Wizard\MagicForger\Generator\Model;

use Symfony\Component\Console\Attribute\AsCommand;
use Wizard\MagicForger\Generator\BaseGenerator;
use Wizard\MagicForger\Helpers\RelationshipNavigator;

#[AsCommand(name: 'mf:model')]
class ModelGenerator extends BaseGenerator
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $name = 'mf:model';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generates the Model File for a table.';

    /**
     * The type of class being generated.
     *
     * @var string
     */
    protected $type = 'Model';

    protected static $cached_snippets = [];

    /**
     * Execute the console command.
     */
    public function handle()
    {

        $belongs_to_many_relations = RelationshipNavigator::getRelations($this->getTableInput());
				dd($belongs_to_many_relations);
        echo $this->renderBelongsToMany($belongs_to_many_relations['hasManyThrough'][0]);
        dd('here');
        /* parent::handle(); */
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub()
    {
        if (! is_null(RelationshipNavigator::isPivot($this->getCurrentTable()))) {
            return $this->resolveStubPath('/stubs/model.pivot.stub');
        }

        return $this->resolveStubPath('/stubs/model.stub');
    }

    /**
     * Resolve the fully-qualified path to the stub.
     *
     * @param  string  $stub
     * @return string
     */
    protected function resolveStubPath($stub)
    {
        return is_file($customPath = $this->laravel->basePath(trim($stub, '/')))
            ? $customPath
            : __DIR__.$stub;
    }

    protected function getClassName($name)
    {
        return $this->model_name($name);
    }

    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getPath($name = null)
    {
        return str_replace(['App\\', '\\'], ['app/', '/'], $this->getModelNamespace().'/'.$this->model_name($this->getTableInput()).'.php');
    }

    protected function getSnippet($snippet_name)
    {
        if (! isset($cached_snippets[$snippet_name])) {
					$cached_snippets[$snippet_name] = $this->files->get(
						$this->resolveStubPath("/snippets/$snippet_name.stub"));
        }

        return $cached_snippets[$snippet_name];
    }

		protected function gatherRelations() {
			$relations = RelationshipNavigator::getRelations($this->getCurrentTable());

			return renderRelations($relations);
			
		}

		protected function renderRelations($relations) {
			$renders = [
				'belongsTo' => [],
				'hasMany' => [],
				'belongsToMany' => [],
			];
			foreach($relations['belongsTo'] as $belongs_to_relation) {
				$renders['belongsTo'] = $this->renderBelongsTo($belongs_to_relation);
			}

			foreach($relations['hasMany'] as $has_many_relation) {
				$renders['hasMany'] = $this->renderHasMany($has_many_relation);
			}

			foreach($relations['belongsToMany'] as $belongs_to_many_relation) {
				$renders['belongsToMany'] = $this->renderBelongsToMany($belongs_to_many_relation);
			}
			return $renders;
		}

    protected function renderBelongsTo($relationship)
    {
        $snippet = $this->getSnippet('belongs_to_relation');
        $relationName = Str::singular($relationship['table']);
        $relatedModel = $this->getClassName($relationship['table']);
        $columnName = $relationship['column'];

        // Replace placeholders with actual values
        $string = str_replace(
            ['{{relationName}}', '{{relatedModel}}', '{{pivotTable}}', '{{foreignPivotKey}}', '{{relatedPivotKey}}'],
            [$relationName, $relatedModel, $pivotTable, $foreignPivotKey, $relatedPivotKey],
            $snippet
        );

        return $string;
    }

    protected function renderBelongsToMany($relationship)
    {
        $snippet = $this->getSnippet('belongs_to_many_relation');
        $relationName = $relationship['table'];
        $relatedModel = $this->getClassName($relationship['table']);
        $pivotTable = $relationship['through']['table'];
        $foreignPivotKey = $relationship['through']['external_column'];
        $relatedPivotKey = $relationship['through']['internal_column'];

        // Replace placeholders with actual values
        $string = str_replace(
            ['{{relationName}}', '{{relatedModel}}', '{{pivotTable}}', '{{foreignPivotKey}}', '{{relatedPivotKey}}'],
            [$relationName, $relatedModel, $pivotTable, $foreignPivotKey, $relatedPivotKey],
            $snippet
        );

        return $string;
    }
}
