function PopupCommand(command)
	let buf = term_start(a:command, {'hidden': 1, 'term_finish': 'close'})
	let winid = popup_create(buf, {'minwidth': 120, 'minheight': 28})
endfunction

function! ReadOnlyPopup(content)
  let lines = split(a:content, "\n")
  let winid = popup_create(lines, {'minwidth':120, 'minheight':28})
  let buf = winbuf(winid)
  call setbufvar(buf, '&modifiable', 0)
  call setbufvar(buf, '&bufhidden', 'wipe')
endfunction

function! ExecuteCommand(command)
  " a:command is a shell command string, e.g. 'hg status'
  return system(a:command . ' 2>&1')
endfunction
