let g:hg_format_command = ""


function! s:CommitWithFormat()
  wa
  if exists("g:hg_format_command") && !empty(g:hg_format_command)
    execute '!'.g:hg_format_command
  endif
  execute '!hg addremove && hg commit'
endfunction

function! s:OpenHgDiff(file)
  let l:current_file = a:file !=# '' ? a:file : expand('%')
  let l:filetype = &filetype
  let l:temp_file = tempname()
  execute 'tabnew'
  execute 'silent !hg cat -r . ' . l:current_file . ' > ' . l:temp_file
  execute 'edit ' . l:temp_file
  execute 'setfiletype' l:filetype
  setlocal buftype=nofile bufhidden=wipe nobuflisted noswapfile 
  execute 'vert diffsplit' l:current_file
endfunction





command HGDiff call s:OpenHgDiff(expand('%'))
command Commit call s:CommitWithFormat()

map <C-k> :Commit<CR>
nnoremap <Leader>df :HGDiff<CR>
