let g:hg_format_command = ""


function PopupCommand(command)
	let buf = term_start(a:command, {'hidden': 1, 'term_finish': 'close'})
	let winid = popup_create(buf, {'minwidth': 50, 'minheight': 20})
endfunction

function ExecuteCommand(command)
  return system(a:command . ' 2>&1')
endfunction

function! s:CommitWithFormat()
  wa
  if exists("g:hg_format_command") && !empty(g:hg_format_command)
    execute '!'.g:hg_format_command
  endif
  execute 
  call ExecuteCommand('!hg addremove')
  call PopupCommand('hg commit')
endfunction

function! s:OpenHgDiff(file)
  let l:current_file = a:file !=# '' ? a:file : expand('%')
  let l:filetype = &filetype
  let l:temp_file = tempname()
  let l:command = 'hg cat -r . ' . l:current_file . ' > ' . l:temp_file
  call ExecuteCommand(l:command)
  execute 'tabe ' . l:temp_file
  execute 'setfiletype' l:filetype
  setlocal buftype=nofile bufhidden=wipe nobuflisted noswapfile 
  execute 'vert diffsplit' l:current_file
endfunction

command HGDiff call s:OpenHgDiff(expand('%'))
command Commit call s:CommitWithFormat()

map <C-k> :Commit<CR>
nnoremap <Leader>df :HGDiff<CR>
