let g:db_user = "budgeter_db_user"      " Replace with your default database username
let g:db_password = "qSTedfw39(0"  " Replace with your default database password
let g:db_name = "budgeter"      " Replace with your default database name
let g:db_host = "127.0.0.1"      " Replace with your default database name


function! s:ExecuteDBQuery(query)
    " Fetch the list of tables from the database
    let db_user = shellescape(g:db_user)
    let db_password = shellescape(g:db_password)
    let db_name = shellescape(g:db_name)
    let db_host = shellescape(g:db_host)

    " Command to fetch tables
    let command = 'mariadb --user=' . db_user . ' --password=' . db_password . ' -e "' . a:query . '" --database=' . db_name . ' --host=' . db_host
    " echo "Running command: " . command
    " Capture both stdout and stderr
    let result = systemlist(command . ' 2>&1')

    " Check for errors
    if v:shell_error != 0
        echoerr "Shell command failed: " . command
        echoerr join(result, "\n")
        return
    endif
    return result
endfunction


function! s:OpenDBTablesWindow()
    " Open a new vertical split window
    execute '34 vsplit'
    " Create a new buffer
    enew
    " Set buffer name to "DBTables"
    file DBTables

    let tables = s:ExecuteDBQuery("SHOW TABLES;")

    " Display the tables in the buffer
    call append(0, 'Available Tables:')
    call remove(tables, 0)
    for table in tables
        call append('$', table)
    endfor

    " Set buffer options
    setlocal buftype=nofile
    setlocal bufhidden=wipe
    setlocal nobuflisted
    setlocal noswapfile
    setlocal nomodifiable
    setlocal nonumber
    setlocal norelativenumber
    setlocal winfixwidth

    " Map <Enter> to a function that displays table data
    nnoremap <buffer> <CR> :call <SID>ShowTableData()<CR>
endfunction


function! s:ShowTableData()
    " Get the current line (table name)
    let lnum = line('.')
    let table_name = getline(lnum)

    " Open a new tab and create a new buffer
    tabnew
    enew
    " Set buffer name to the table name
    execute 'file ' . table_name

    let data = s:ExecuteDBQuery("SELECT * FROM " . table_name . ";")

    " Display the table data in the buffer
    if len(data) > 0
        call append(0, data)
    else
        call append(0, 'No data found.')
    endif

    " Set buffer options
    setlocal buftype=nofile
    setlocal bufhidden=wipe
    setlocal nobuflisted
    setlocal noswapfile
    setlocal nomodifiable
endfunction

function! s:ExecuteSQLQuery()
    " Get the content of the current buffer (SQL query)
    let query = join(getline(1, '$'), " ")
    let db_user = shellescape(g:db_user)
    let db_password = shellescape(g:db_password)
    let db_name = shellescape(g:db_name)

    let data = s:ExecuteDBQuery(query)

    tabnew
    enew
    execute 'file SQLQueryResult'
    call append(0, data)
    setlocal buftype=nofile
    setlocal bufhidden=wipe
    setlocal nobuflisted
    setlocal noswapfile
    setlocal nomodifiable
endfunction

function! DBConsole()
  " Save the current cursor position
  let save_cursor = getpos(".")

  "Format the files
  let db_user = g:db_user
  let db_password = g:db_password
  let db_name = g:db_name
  " let db_host = shellescape(g:db_host)
  let db_host = g:db_host



  let command = 'mariadb --user=' . db_user . ' --password=' . db_password . ' --database=' . db_name . ' --host=' . db_host . ' '
  let command =  substitute(command, '\n', '', 'g')
  execute ':term ' . command
  call setpos(".", save_cursor)
endfunction

function! OpenMariaDBConsole()
  " The command to connect to MariaDB. Customize it with your actual connection details.
  let cmd = 'mariadb -u your_username -p your_database_name'

  " Open a new terminal window at the bottom with 10 lines height.
  " Split the window horizontally; you can adjust the height by changing `10`.
  botright 10split
  call termopen(cmd)
endfunction

nnoremap <Leader>db :call DBConsole()<cr>

command! DBTables call s:OpenDBTablesWindow()
command! ExecuteSQL call s:ExecuteSQLQuery()
