function! GrepIncludingIgnored(pattern, path = '**/*')
   if a:pattern =~ '^/.*/[a-z]*$'
       let search_pattern = a:pattern
   else
       let search_pattern = '/' . a:pattern . '/g'
   endif

   execute 'vimgrep ' . search_pattern . ' ' . a:path
endfunction

" Map it to a command for easy use
command! -nargs=+ GlobalSearch call GrepIncludingIgnored(<f-args>)
command! -nargs=+ GS call GrepIncludingIgnored(<f-args>)
